/*
 * RunWindow.java
 *
 * Created on January 5, 2010, 2:06 PM
 *
 * To change this template, choose Tools | Template Manager
 * and display the template in the editor.
 */
package org.biolegato.menu;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import org.biolegato.main.BLMain;

/**
 *
 * @author alvare
 */
public class RunWindow implements ActionListener {

    /**
     * The name of the window
     */
    private String name = null;
    /**
     * The current window
     */
    protected JDialog runWindow = null;
    /**
     * List of buttons for the window.
     */
    protected List<CommandButton> buttons;
    /**
     * List of widgets for the window.
     */
    protected Map<String, Widget> widgets;
    /**
     * Action for command buttons to close the window.
     * A good example usage is closing the window when running a program
     */
    public final AbstractAction CLOSE_ACTION = new AbstractAction("close") {
        public void actionPerformed(ActionEvent e) {
            if (runWindow != null) {
                runWindow.setVisible(false);
                runWindow.dispose();
                runWindow = null;
            }
        }
    };
    /**
     * Used in serialization.
     */
    private static final long serialVersionUID = 7526472295622777007L;
    /**
     * The initial size for the run window
     */
    private static final Dimension INITIAL_SIZE = new Dimension(100, 100);
    /**
     * The minimum size for the run window
     */
    private static final Dimension MINIMUM_SIZE = new Dimension(50, 50);

    /**
     * Creates a new instance of RunWindow
     */
    public RunWindow(String name, List<CommandButton> buttons, Map<String, Widget> widgets) {
        this.name = name;
        this.widgets = widgets;
        this.buttons = buttons;
    }
   
    public void actionPerformed(ActionEvent e) {
        Container variablePane = new Box(BoxLayout.PAGE_AXIS);
	Container buttonPane = new Box(BoxLayout.LINE_AXIS);
        
        for (Widget w : widgets.values()) {
            w.display(variablePane);
        }
        
        for (CommandButton b : buttons) {
            b.display(buttonPane, this);
        }

        runWindow = new JDialog(BLMain.getJFrame(), "BioLegato: " + name, true);
        Container panel = null;
        Container windowPane = new Box(BoxLayout.PAGE_AXIS);

        // create the pane and make it scrollable
        runWindow.setContentPane(new JScrollPane(windowPane));
        windowPane.add(variablePane);
        windowPane.add(buttonPane);

        // clean up and display the window
        runWindow.setMinimumSize(MINIMUM_SIZE);
        runWindow.setSize(INITIAL_SIZE);
        runWindow.setLocationRelativeTo(BLMain.getJFrame());
        runWindow.setVisible(false);

        runWindow.pack();
        runWindow.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
        runWindow.setVisible(true);
    }
}
