package org.biolegato.menu;

import java.awt.Container;
import java.io.File;
import java.io.IOException;
import org.biolegato.main.BLMain;

/**
 * Stores information about the file fields used by the command
 **
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class TempFile implements Widget {

    String source = null;
    String dest = null;
    /**
     * The currently opened file handle.
     */
    private File currentFile = null;
    /**
     * Whether or not to add the contents of the window to the file before execution
     * (whether the temporary file is input for a program).
     */
    private boolean input = false;
    /**
     * Whether or not to add the contents of the file to the window after execution.
     * (whether the temporary file is output for a program).
     */
    private boolean output = false;
    /**
     * Determines whether or not to delete the file after execution.
     */
    private boolean save = false;
    /**
     * Determines whether or not to overwrite the file if it already exists.
     */
    private boolean overwrite = false;
    /**
     * Stores the file format of the file (used for translation).
     */
    private String format = null;

    /**
     * Creates a new instance of EZComboBox (represents "choice_list" in GDE menu files).
     *
     * @param data the data to create the combobox with.
     */
    public TempFile(boolean input, boolean output, boolean save, boolean overwrite, String format) {
        this.input = input;
        this.output = output;
        this.save = save;
        this.overwrite = overwrite;
        this.format = format;
    }

    /**
     * Gets the current filename corresponding to this variable
     * If the file does not exists, then this function creates a file to
     * use for IO and writes any initial contents
     *
     * @return the filename to use for command line substitution.
     */
    public Object getValue() {
        String result = "";    // the filename to use
        String data = "";    // the data to insert into the file
        File location = new File(BLMain.envreplace(BLMain.getProperty("temp")));

        if (currentFile == null) {
            try {
                if (!location.exists() && !location.isDirectory()) {
                    location = new File(BLMain.CURRENT_DIR);
                }

                // create the file
                currentFile = File.createTempFile("bio", null, location);
                if (!save) {
                    currentFile.deleteOnExit();
                }

                if (input && format != null) {
                    // write the file
                    BLMain.getCanvas().writeFile(format, currentFile);
                } else if (format == null) {
                    BLMain.error("Invalid file format (null)", "GDETempFile");
                }
            } catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
        }
        if (currentFile != null) {
            result = currentFile.getName();
            // TODO: replace with getPath in the new file format
        }
        return (result != null && !"".equals(result.trim()) ? result : "nullfile");
    }

    /**
     * Releases any files currently in use by this class
     */
    public void close() {
        // releases all of the files
        if (currentFile != null && currentFile.exists()) {
            if (output) {
                if (format != null) {
                    BLMain.getCanvas().readFile(format, currentFile);
                } else {
                    BLMain.error("Invalid file format", "GDETempFile");
                }
            }
            if (!save) {
                currentFile.delete();
            }
        }
        currentFile = null;
    }

    /**
     * Displays the current widget
     **
     * @param dest the destination to display the widget
     */
    public void display(Container dest) {
    }
}
