/*
 * ClipboardWrapper.java
 *
 * Created on November 25, 2010, 10:19 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.biolegato.gdesupport.data;

import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

/**
 *
 * @author alvare
 */
public final class ClipboardWrapper implements Transferable {
///////////////////////
//*******************//
//* CLASS VARIABLES *//
//*******************//
///////////////////////
    /**
     * Stores the data to export
     */
    private Seq[] cellArray;
    /**
     * A data flavour representing the raw Cell data type.
     */
    public static final DataFlavor sequenceArrayFlavour = new DataFlavor(Seq[].class, "Raw BioLegato sequence array");
    
//////////////////////
//******************//
//* CONSTRUCTOR(S) *//
//******************//
//////////////////////
    /**
     * Creates a new instance of ClipboardWrapper
     **
     * @param cellArray the data to store in the wrapper
     */
    public ClipboardWrapper(Seq[] cellArray) {
        this.cellArray = cellArray;
    }

///////////////////////////
//***********************//
//* CLIPBOARD FUNCTIONS *//
//***********************//
///////////////////////////
    /**
     * Obtains the current contents of the clipboard (null if empty).
     *
     * @return the current contents of the clipboard.
     */
    public static Seq[] getClipboard() {
        String string;
        Seq[] clipboard = null;
        Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);

        try {
            if (t != null) {
                System.out.println("T IS NOT NULL");
                if (t.isDataFlavorSupported(ClipboardWrapper.sequenceArrayFlavour)) {
                    clipboard = ((Seq[]) t.getTransferData(ClipboardWrapper.sequenceArrayFlavour));
                    System.out.println("SEQ[]! " + clipboard);
                } else if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    string = (String) t.getTransferData(DataFlavor.stringFlavor);
                    clipboard = new Seq[]{new Seq(Seq.Type.DNA, "", new StringBuffer(string))};
                    System.out.println("STRING! " + string);
                } else {
                    System.out.println("UNSUPPORTED PASTE!!!!! " + t.getTransferDataFlavors());
                }
            } else {
                System.out.println("T IS NULL");
                throw new IOException();
            }
        } catch (UnsupportedFlavorException e) {
            e.printStackTrace(System.err);
        } catch (IOException e) {
            e.printStackTrace(System.err);
        }
        return clipboard;
    }

    /**
     * Changes the current contents of the clipboard.
     *
     * @param copy the new content for the clipboard.
     */
    public static void setClipboard(Seq[] copy) {
        Seq[] result = new Seq[copy.length];
        for (int count = 0; count < copy.length; count++) {
            result[count] = new Seq(copy[count]);
        }
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new ClipboardWrapper(result), null);
    }
    
////////////////////
//****************//
//* TRANSFERABLE *//
//****************//
////////////////////
    /**
     * Dictates what formats the Dataset can be converted to.
     **
     * @return an array of supported formats
     */
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{sequenceArrayFlavour, DataFlavor.stringFlavor};
    }

    /**
     * Dictates whether a given format is supported for conversion
     **
     * @param flavour the flavour to test for compatability
     * @return true if the format is supported
     */
    public boolean isDataFlavorSupported(DataFlavor flavour) {
        boolean result = false;
        DataFlavor[] test = getTransferDataFlavors();

        for (int count = 0; count < test.length && !result; count++) {
            result = flavour.equals(test[count]);
        }
        return result;
    }

    /**
     * Translates the Dataset to the given format
     **
     * @param flavour the data flavour to use for translation
     * @return the translated object
     * @throws UnsupportedFlavorException if the SeqDatasetnnot be translated into the requested data flavour
     * @throws IOException if there is a problem with I/O during the translation
     */
    public Object getTransferData(DataFlavor flavour) throws UnsupportedFlavorException, IOException {
        Object result = cellArray;

        if (!isDataFlavorSupported(flavour)) {
            throw new UnsupportedFlavorException(flavour);
        }
        if (DataFlavor.stringFlavor.equals(flavour)) {
            result = toString();
        }
        return result;
    }

//////////////////////
//******************//
//* DATA FUNCTIONS *//
//******************//
//////////////////////
    /**
     * Dumps the data contained within the clipboard wrapper
     **
     * @return the data contained within the wrapper
     */
    public Seq[] toArray () {
        return cellArray;
    }
}
