/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.biolegato.gdesupport.data;

import java.awt.Color;
import java.awt.Graphics;

/**
 *
 * @author alvare
 */
public final class ColourMask {
    public static enum MaskType {
        POSITION, CHARACTER;
    }
    
    /**
     * The current default FOREG colour of normal unselected text
     */
    public static final Color FOREG = Color.BLACK;
    /**
     * The functional maximum size of the hashtable.
     */
    public static final int HASH_SIZE = 36;

    MaskType type;
    Color[] colours;
    String name;

    public ColourMask (MaskType type, String name, Color[] colours) {
        this.type = type;
        this.colours = colours;
        this.name = name;
    }

    @Override
    public String toString() {
        return name;
    }

    public void drawString (Graphics gfx, char[] array, int xstart, int y, int start, int end) {
        int hashpos = 0;
        final int width = gfx.getFontMetrics().charWidth('G');

        end = Math.min(array.length - 1, end);

        for (int index = start, x = xstart; index < end; index++, x+= width) {
            if (type == MaskType.CHARACTER) {
                gfx.setColor(get_hash(array[index]));
            }else if(index < colours.length) {
                gfx.setColor(colours[index]);
            } else {
                gfx.setColor(FOREG);
            }
            gfx.drawChars(array, index, 1, x, y);

        }
    }

    private Color get_hash(char test) {
        if (test >= 'a' && test <= 'z') {
            return colours[test - 'a'];
        } else if(test >= 'A' && test <= 'Z') {
            return colours[test - 'A'];
        } else if(test >= '0' && test <= '9') {
            return colours[test - '0' + 26];
        }
        return FOREG;
    }

    public static int hash(char test) {
        if (test >= 'a' && test <= 'z') {
            return test - 'a';
        } else if(test >= 'A' && test <= 'Z') {
            return test - 'A';
        } else if(test >= '0' && test <= '9') {
            return test - '0' + 26;
        }
        return -1;
    }
}
