package org.biolegato.menu;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import org.biolegato.main.BLMain;

/**
 * A wrapper class used to abstract file selection within command windows.
 **
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class FileChooser extends TextWidget implements ActionListener {
    
    /**
     * Creates a new instance of GDETempFile.
     *
     * @param data the data to create the temporary file variable with.
     */
    public FileChooser(String label, String value) {
        super(label, value);
    }

    /**
     * Handle the choose file button
     *
     * @param e ignored because there is only one widget calling this method.
     */
    public void actionPerformed(ActionEvent e) {
        JFileChooser openDialog = new JFileChooser();
        openDialog.setCurrentDirectory(BLMain.getCurrentPWD());
        openDialog.setAcceptAllFileFilterUsed(true);

        // if a file is selected, display it
        if (openDialog.showOpenDialog(BLMain.getJFrame()) == JFileChooser.APPROVE_OPTION) {
            textfield.setText("\"" + openDialog.getSelectedFile().getPath() + "\"");
	    if (openDialog.getCurrentDirectory() != null) {
		BLMain.setCurrentPWD(openDialog.getCurrentDirectory());
	    }
        }
    }

    /**
     * Displays the file chooser widget
     **
     * @param dest the destination to display the file chooser widget
     */
    @Override
    public void display(Container dest) {
        Box result = new Box(BoxLayout.LINE_AXIS);
        JButton pickFile = new JButton("Choose file...");

        pickFile.addActionListener(this);

        super.display(result);
        result.add(pickFile);
        
        dest.add(result);
    }
}
