package org.biolegato.tables;
/*
 * CSVFile.java
 *
 * Created on January 30, 2008, 11:58 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import javax.swing.filechooser.FileFilter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import javax.swing.table.DefaultTableModel;

/**
 * CSV file format parser.
 **
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class CSVFile extends FileFilter {

    /**
     * Creates a new instance of CSVFile
     */
    public CSVFile () {
    }
    /**
     * Determines whether or not a specified file is of type GenBank file (based on extension).
     * Currently the only extensions supported is ".csv".
     **
     * @param file the file to test
     * @return true if the file is of type FastA file (otherwise false)
     * @see javax.swing.filechooser.FileFilter#accept
     */
    public boolean accept (File file) {
        return (file.isDirectory() ||
                file.getAbsolutePath().toLowerCase().endsWith(".csv"));
    }
    /**
     * Returns a description of the file format that can be displayed to the user.
     **
     * @return the string description of the file format
     * @see javax.swing.filechooser.FileFilter#getDescription
     */
    public String getDescription () {
        return "CSV - Comma Separated Values - file (*.csv)";
    }
    /**
     * Used to auto-detect Bio Legato formats
     **
     * @param test the reader to parse data from
     * @return whether or not the format is correct
     */
    public boolean isFormat (Reader test) {
        int check = ' ';
        try {
            while (check != '\n' && check != '\r' && check != ',') {
                test.mark(2);
                check = test.read();
            }
            test.reset();
        } catch (IOException e) {
            e.printStackTrace(System.err);
        }
        return (check == ',');
    }

    public static void readFile(DefaultTableModel table, File currentFile) {
        String line;
        String[] row;
        BufferedReader reader;
        
        try {
            reader = new BufferedReader(new FileReader(currentFile));
            
            while ((line = reader.readLine()) != null) {
                row = line.split(",");
                while (table.getColumnCount() < row.length) {
                    table.addColumn("" + table.getColumnCount());
                }
                table.addRow(row);
            }
        } catch (IOException th) {
            th.printStackTrace(System.err);
        }
    }

    public static void writeFile(File currentFile, String[][] data) {
        String cell;
        FileWriter writer;   // the file writer object to write the file with.
        
        try {
            writer = new FileWriter(currentFile);
            
            // translate and write the file.
            for (int y = 0; y < data.length; y++) {
                if (data[y].length > 0) {
                    writer.append('\"');
                    writer.append(data[y][0].replaceAll("\"", "\"\""));
                    writer.append('\"');
                }
                for (int x = 0; x < data[y].length; x++) {
                    cell = data[y][x];
                    writer.append(',');
                    writer.append('\"');
                    if (cell != null) {
                        writer.append(cell.replaceAll("\"", "\"\""));
                    }
                    writer.append('\"');
                }
                writer.append('\n');
            }
        
            // flush and close the file writer buffer.
            writer.flush();
            writer.close();
        } catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
    }
}
