package org.biolegato.menu;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

/**
 * Wrapper class for a group of radiobuttons.
 **
 * NOTE: This can be added to any JContainer since it extends JPanel.
 **
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class Chooser extends ListWidget implements ActionListener {
    /**
     * Required for serialization purposes.
     */
    private static final long serialVersionUID = 7526472295622776152L;
    private String value;
    
    /**
     * Creates a new instance of EZChooser.
     *
     * @param data The value/name list of each of the radiobuttons
     */
    public Chooser(String label, String[] names, String[] values, int index) {
        super(label, names, values, index);
        if (index < values.length) {
            value = values[index];
        }
    }

    /**
     * Displays the chooser widget
     **
     * @param dest the destination to display the chooser widget
     */    
    public void display(Container dest) {
        Box result = new Box(BoxLayout.LINE_AXIS);
        String[] entries = null;
        ButtonGroup group = new ButtonGroup();
        JPanel panel = new JPanel();
        JRadioButton radio;
        
        if (label != null) {
            result.add(new JLabel(label));
        }
        
        for (int count = 0; count < names.length; count++) {
            radio = new JRadioButton(names[count]);
            panel.add(radio);
            radio.setActionCommand(values[count]);
            radio.addActionListener(this);
            if (value.equals(values[count])) {
                radio.setSelected(true);
            }
            group.add(radio);
        }
        result.add(panel);
        
        dest.add(result);
    }
   
    /**
     * Handles selection changes of the radio buttons.
     *
     * @param e used to determine which button is selected (by use of getActionCommand()).
     */
    public void actionPerformed(ActionEvent e) {
        value = e.getActionCommand();
    }
    
    /**
     * Returns the value of the variable.
     *
     * @return the current value of the variable
     */
    public Object getValue() {
        return value;
    }

    public void close() {
    }
}
