/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.biolegato.menu;

import java.awt.Container;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneConstants;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;

/**
 * A wrapper class used to abstract combo boxes within command windows.
 **
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class ComboBoxWidget extends ListWidget {
    /**
     * The combobox contianing the data
     */
    protected JComboBox combobox = null;
    /**
     * The UI to enable scrolling of the JComboBox.
     */
    public final BasicComboBoxUI COMBOBOX_UI = new BasicComboBoxUI() {
        @Override
                protected ComboPopup createPopup() {
            BasicComboPopup uipopup = new BasicComboPopup(comboBox){
                @Override
                        protected JScrollPane createScroller() {
                    return new JScrollPane( list, ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED,
                            ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED );
                }
            };
            return uipopup;
        }
    };
    /**
     * used for serialization
     */
    private static final long serialVersionUID = 7526472295622776158L;
    
    /**
     * Creates a new instance of EZComboBox (represents "choice_list" in GDE menu files).
     *
     * @param data the data to create the combobox with.
     */
    public ComboBoxWidget(String label, String[] names, String[] values, int index) {
        super(label, names, values, index);
    }
    
    /**
     * Displays the combobox widget
     **
     * @param dest the destination to display the combobox widget
     */    
    public void display(Container dest) {
        Box result = new Box(BoxLayout.LINE_AXIS);
        int defaultEntry = 0;
        String[] orderChoices = null;         // used for default values
        
        // a combo box which returns its value when toString is called
        if (label != null) {
            result.add(new JLabel(label));
        }
        
        combobox = new JComboBox(names);
        
        // handle the default value for the list
        combobox.setSelectedIndex(index);
        combobox.setUI(COMBOBOX_UI);
        combobox.updateUI();
        result.add(combobox);
        
        dest.add(result);
    }
    
    /**
     * Returns the value of the variable.
     *
     * @return the value of the variable.
     */
    public Object getValue() {
        return values[combobox.getSelectedIndex()];
    }
    
    public void close() {
        index = combobox.getSelectedIndex();
        combobox = null;
    }
}
