package org.biolegato.menu;

/**
 * A wrapper class used to abstract combo boxes within command windows.
 **
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public abstract class ListWidget implements Widget {
    /**
     * Stores the current value selected by the chooser.
     */
    protected int index = 0;
    /**
     * The label to associate with the list widget
     */
    protected String label = null;
    /**
     * The list of choice names
     */
    protected String[] names = null;
    /**
     * The list of choice values
     */
    protected String[] values = null;
    /**
     * used for serialization
     */
    private static final long serialVersionUID = 7526472295622776158L;


    /**
     * Creates a new instance of EZComboBox (represents "choice_list" in GDE menu files).
     *
     * @param data the data to create the combobox with.
     */
    public ListWidget(String label, String[] names, String[] values, int index) {
        this.label = label;
        this.names = names;
        this.values = values;
        this.index = index;
    }
}