/*
 * Canvas.java
 *
 * Created on November 7, 2007, 1:12 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */
package org.biolegato.main;

import java.awt.Component;
import java.io.File;

/**
 * All subclasses are expected to implement a displayable canvas for BioLegato.
 * 
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public interface DataCanvas {
    /**
     * Displays the main pane of the data canvas
     */
    public Component display();
    /**
     * Reads a file into the canvas
     **
     * @param format the file format to use for parsing the file.
     * @param currentFile the file to read in.
     */
    public void readFile(String format, File currentFile);
    /**
     * Writes a file out from the canvas
     **
     * @param format the file format to use for writing the file.
     * @param currentFile the file to write out.
     */
    public void writeFile(String format, File currentFile);
    /**
     * Returns the name of the canvas.
     **
     * @return the name to display for the canvas in all program text referring to it.
     */
    public String getName ();
}
