/*
 * GDECanvasObject.java
 *
 * Created on August 26, 2010, 11:30 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.biolegato.gdesupport.canvas;

import java.io.IOException;
import org.biolegato.gdesupport.files.DataFormat;

/**
 *
 * @author alvare
 */
public interface GDECanvasObject {

    /**
     * Cuts content from the current Editable object.
     */
    public void deleteSelection();

    public void writeOut(DataFormat format, Appendable dest) throws IOException;

    /**
     * Pastes content into the current Editable object.
     */
    public void paste();

    /**
     * Changes the case of the currently selected sequence
     * (if the sequence is of inconsistent case, the case of the entire sequence
     * is changed to the opposite case of the first character in the sequence.
     */
    public void changeCase ();

    public void copyClipboard();
}
