package blrevcomp;

import java.io.*;


/**Types and methods for safely opening or closing
an output file for writing lines of text.
*/
public class BufferedTextOutputFile {
    public File F;
    public FileWriter FW;
    public BufferedWriter BW;        
    
/**Open file and create FileWriter and BufferedWriter.
* @param S String containing name of file to be opened*/        
    public boolean WriteOkay (String S) {
      boolean OKAY = true;   
      F = new File(S);
      try {FW = new FileWriter(F);
	   BW = new BufferedWriter(FW);
	  }
      catch (IOException e) {OKAY = false;
			     System.out.println("I/O Error in BufferedTextOutputFile.WriteOkay");
			     System.err.println(e.getMessage());} ;
      return OKAY;             
       } // WriteOkay


/** Write a character to a file. */
    public void writeChar (char CH) {
      try {BW.write(CH);}
      catch (IOException e) {System.err.println(e.getMessage());}
    }
      
     public void writeChar (Character CH) {
      try {BW.write(CH.charValue());}
      catch (IOException e) {System.err.println(e.getMessage());}
          
      } //writeChar  

    
/** Write a string to a file */
    public void write (String S) {
      try {BW.write(S);
	  }
      catch (IOException e) {System.out.println("I/O Error in BufferedTextOutputFile.writeln");
			     System.err.println(e.getMessage());}
      } //write       
	                        
/** Write a line to a file, terminated by a newline character */
    public void writeln (String S) {
      try {BW.write(S);
	   BW.newLine();
	  }
      catch (IOException e) {System.out.println("I/O Error in BufferedTextOutputFile.writeln");
			     System.err.println(e.getMessage());}
      } //writeln       
	                  
} // BufferedTextOutputFile

