/*
 * Main.java
 *
 * Created on May 18, 2009, 3:01 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package blrevcomp;


import java.io.*;
import java.util.*;

//------------------------------------------------------------
/**
 * Type wrapper for "global parameters" 
 */
class Params { 
    int SENSE = -1;
    char STRAND = 'c';
    String SUFFIX = "-opp";
    String IFN;
    String OFN;
    BufferedTextInputFile Infile;
    BufferedTextOutputFile Outfile;
    
    boolean ParseArgs(String[] args) {
       boolean OKAY = false;
       if (args != null ) { 
          for (String argument : args) { 
              if (argument.equals("-r")) { 
                 SENSE = -1;
                 STRAND = 'c';
                 SUFFIX = "-opp";
              }
              else if (argument.equals("-c")) {
                 SENSE = 1;
                 STRAND = 'c';
                 SUFFIX = "-comp";
              }
              else if (argument.equals("-f")) {
                 SENSE = -1;
                 STRAND= 'i';
                 SUFFIX = "-flip";
              }
              else if (IFN == null) {
                  IFN = argument;                                
              }
              else if (OFN == null) {
                  OFN = argument;
                  OKAY = true;
              }              
          }               
       }
       //System.out.println("IFN: " + IFN);
       //System.out.println("OFN: " + OFN);       
    return OKAY;
    }
    } // Params

/**
 *
 * @author Brian Fristensky
 */
public class Main {
    
    /** Creates a new instance of Main */
    public Main() {
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        
        // Command line parameters
        Params P = new Params();
        P.Infile = new BufferedTextInputFile();	       
        P.Outfile = new BufferedTextOutputFile();
        if (P.ParseArgs(args)) {           
           // Open input and output files
           if (P.Infile.OpenOkay(P.IFN) && P.Outfile.WriteOkay(P.OFN)) {
              // Sequence array
              BioSeq CurrentSeq = new BioSeq();
              while (CurrentSeq.readFasta(P.Infile)) {
                  CurrentSeq.writeFasta(P.Outfile,P.SUFFIX,P.STRAND,P.SENSE,50);
              }
              try {P.Infile.BR.close();
              //P.Outfile.BW.flush(); // do we need this?
              P.Outfile.BW.close();}
              catch (IOException e){
              System.out.println(">>> Error closing " + 
					 P.Outfile.F.getName());
		      System.err.println(e.getMessage());}
              }
           
        }
     }
}
