//=====================================================================
// File:    PeakLocate.java
// Class:   PeakLocate
// Package: AFLPcore
//
// Author:  James J. Benham
// Date:    August 10, 1998
// Contact: james_benham@hmc.edu
//
// Genographer v1.0 - Computer assisted scoring of gels.
// Copyright (C) 1998  Montana State University
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; version 2
// of the License.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// The GNU General Public License is distributed in the file GPL
//=====================================================================

package AFLPcore;

/**
 * This is an abstract class that should be extended to provide different
 * ways of finding the peaks in a lane. Examples include simply waiting for
 * a change in slope or something more complicated like a neural net. The
 * <code>MIN</code> and <code>MAX</code> should always specify the first and
 * last data points in the lane given.
 *
 * @author James J. Benham
 * @version 1.0.0
 * @date August 10, 1998
 */

public abstract class PeakLocate extends Operation
{
  /**Specifies the smallest value in a lane is to be used.*/
  public static double MIN = -1;
  /**Specifies the largest value in a lane is to be used.*/
  public static double MAX = -1;

  /**
   * Finds the peaks in the given lanes and only finds those whose size is
   * greater than or equal to minSize and less than or equal to maxSize.
   * The peaks that are found will be stored in the given lanes.
   * 
   * @param lanes     the list of lanes that the algorithm should look
   *                  for peaks in.
   * @param minSize   the minimum size of any peak. If the value 
   *                  <code>MIN</code> is given, then the smallest size 
   *                  in the lane will be used.
   * @param maxSize   the maximum size of any peak. If the value
   *                  <code>MAX</code> is given, then the largest size
   *                  in the lane will be used.
   */
  public abstract void findPeak(DataList lanes, double minSize, 
				double maxSize);
}
