//=====================================================================
// File:    EntryDialog.java
// Class:   EntryDialog
// Package: AFLPgui
//
// Author:  James J. Benham
// Date:    August 11, 1998
// Contact: james_benham@hmc.edu
//
// Genographer v1.0 - Computer assisted scoring of gels.
// Copyright (C) 1998  Montana State University
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; version 2
// of the License.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// The GNU General Public License is distributed in the file GPL
//=====================================================================

package AFLPgui;

import java.awt.Button;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

/**
 * This is a dialog that can be used to have the user enter a value.
 * Currently the dialog only supports the entering of a perentage.
 *
 * @author James J. Benham
 * @version 1.0.0
 * @date August 11, 1998
 */

public class EntryDialog extends Dialog implements ActionListener,
                                                   KeyListener,
                                                   WindowListener
{
  private static int WIDTH = 270;
  private static int HEIGHT = 137;

  private static int BUTTON_WIDTH = 80;
  private static int BUTTON_HEIGHT = 22;
  private static int BUTTON_H_INSET = 95;
  private static int BUTTON_H_SPACE = 5;

  private static int FIELD_HEIGHT = 22;
  private static int FIELD_WIDTH = 250;
  private static int H_INSET = 10;
  private static int V_INSET = 25;

  private static int LABEL_HEIGHT = 14;
  private static int LABEL_WIDTH = FIELD_WIDTH;

  private static int V_SPACE = 8;

  private static int PERCENT = 0;

  private Button okButton;
  private Button cancelButton;
  private TextField entryField;
  private Label message1;
  private Label message2;
  private Label message3;

  private Frame parent;

  private String entry;

  private int mode;

  /**
   * Create a new EntryDialog with the specified parameters.
   *
   * @param parent   the owner of this dialog box
   * @param title    the title of the dialog box
   * @param modal    if true, dialog blocks input to the parent window 
   *                 when shown
   */
  public EntryDialog(Frame parent, String title, boolean modal)
  {
    super(parent, title, modal);
    this.parent = parent;

    addWindowListener(this);

    componentLayout();
  }

  /**
   * Shows the dialog box and prompts the user for a percentage.
   *
   * @return the percentage, or -1 if nothing is entered.
   *
   * @exception NumberFormatException occurs when the user fails
   *         to type in a number.
   */
  public double getPercentage()
  {
    mode = PERCENT;

    // could add error check to see if it is already visible.
    message1.setText("Enter a percentage value below.");
    message2.setText("blah");
    message3.setText("");
    entryField.setText("%");
    setVisible(true);
    
    // Make sure it is not null and then return the value. If it is, return
    // -1. 
    // For some reason java is very nice and waits until the dialog is
    // closed before it returns the value. Good java.

    if(entry != null)
      {
	Double value = new Double(-1.0);
	try{
	  value = new Double(entry);
	}catch (NumberFormatException e) {
	  throw new NumberFormatException(entry + 
					  " is not a valid percentage.");
	}
    
	return (value.doubleValue()/100);
      }
    else
      return -1.0;
  }

  /**
   * Handles the events from buttons. If the ok button is clicked, the
   * entry field is read, and the '%' sign removed if the dialog is
   * in percent mode. If cancel if clicked, then the entry is set to
   * <code>null</code>.
   */
  public void actionPerformed(ActionEvent e)
  {
    if(e.getSource() == okButton)
      {
	entry = entryField.getText();
	// remove the '%' sign by replacing it with whitespace and then
	// trimming the string.
        if(mode == PERCENT)
	  {
	    entry = entry.replace('%', ' ');
	    entry = entry.trim();
	  }
	    
	dispose();
	setVisible(false);
      }
    else if(e.getSource() == cancelButton)
      {
	entry = null;
	dispose();
	setVisible(false);
      }
  }

  /**
   * This mehtod does do things: look for the Enter key and add the '%' sign.
   * If the entery key is pressed, it has the same affect as pressing the
   * ok button. If the dialog is in percentage mode, then any other key
   * press will result in the '%' sign being added to the end of the field
   * if one is not already present.
   */
  public void keyReleased(KeyEvent e)
  {
    // Assume that a release of the enter key constitutes the typing
    // of the enter key. It is very unlikely that it got pushed down
    // somewhere else and released here.

    // if it is the enter key, then go on.
    if (e.getKeyCode() == KeyEvent.VK_ENTER)
      {
	entry = entryField.getText();
	// remove the '%' sign by replacing it with whitespace and then
	// trimming the string.
        if(mode == PERCENT)
	  {
	    entry = entry.replace('%', ' ');
	    entry = entry.trim();
	  }

	dispose();
	setVisible(false);
      }

    // Add the percentage sign if neccessary
    if(mode == PERCENT)
      {
	String temp = entryField.getText();
	if( !temp.endsWith("%"))
	  {
	    System.out.println("adding %");
	    temp += "%";
	    entryField.setText(temp);
	  }
      }
    
  }

  /**
   * Closes the window and cancels the dialog box.
   */
  public void windowClosing(WindowEvent e)
  {
	entry = null;
	dispose();
	setVisible(false);    
  }

  /**
   * Adds the components to the dialog box.
   */
  private void componentLayout()
  {
    int startY;

    setLayout(null);

    // center the dialog

    setSize(WIDTH, HEIGHT);
    setResizable(false);
    
    // ============add label=================
    message1 = new Label("Testing multi-line label \n testing...");
    add(message1);
    message1.setBounds(H_INSET, V_INSET, LABEL_WIDTH, LABEL_HEIGHT);
    startY = V_INSET + LABEL_HEIGHT;

    message2 = new Label("line 2");
    add(message2);
    message2.setBounds(H_INSET, startY, LABEL_WIDTH, LABEL_HEIGHT);
    startY += LABEL_HEIGHT;

    message3 = new Label("LINE 3");
    add(message3);
    message3.setBounds(H_INSET, startY, LABEL_WIDTH, LABEL_HEIGHT);
    startY += LABEL_HEIGHT + V_SPACE;
    
    // ===========add text entry field=======
    entryField = new TextField();
    add(entryField);
    entryField.setBounds(H_INSET, startY, FIELD_WIDTH, FIELD_HEIGHT);
    entryField.addKeyListener(this);
    startY += V_SPACE + FIELD_HEIGHT;

    //===========add buttons=================
    okButton = new Button("Ok");
    add(okButton);
    okButton.setBounds(BUTTON_H_INSET, startY, BUTTON_WIDTH, BUTTON_HEIGHT);
    okButton.addActionListener(this);

    cancelButton = new Button("Cancel");
    add(cancelButton);
    cancelButton.setBounds(BUTTON_H_INSET + BUTTON_WIDTH + BUTTON_H_SPACE,
			   startY, BUTTON_WIDTH, BUTTON_HEIGHT);
    cancelButton.addActionListener(this);
    startY += BUTTON_HEIGHT + V_SPACE;
  }

  // ==================Unused methods required by interfaces=================
  /**Unused*/public void keyPressed(KeyEvent e) {}
  /**Unused*/public void keyTyped(KeyEvent e) {}

  /**Unused*/public void windowOpened(WindowEvent e) {}
  /**Unused*/public void windowClosed(WindowEvent e) {}
  /**Unused*/public void windowIconified(WindowEvent e) {}
  /**Unused*/public void windowDeiconified(WindowEvent e) {}
  /**Unused*/public void windowActivated(WindowEvent e) {}
  /**Unused*/public void windowDeactivated(WindowEvent e) {}
}
