//=====================================================================
// File:    Graph.java
// Class:   Graph
// Package: AFLPgui
//
// Author:  James J. Benham
// Date:    August 11, 1998
// Contact: james_benham@hmc.edu
//
// Genographer v1.0 - Computer assisted scoring of gels.
// Copyright (C) 1998  Montana State University
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; version 2
// of the License.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// The GNU General Public License is distributed in the file GPL
//=====================================================================

package AFLPgui;

import java.awt.Graphics;
import AFLPcore.DataList;

/**
 * This abstract class provides a way for other parts of the program to
 * draw graphs easily. Classes can extend this and actually draw the
 * graph. For example, a graph could be a bar graph showing the different
 * peaks in a lane.
 *
 * @author James J. Benham
 * @version 1.0.0
 * @date August 11, 1998
 */

public abstract class Graph
{
  /**
   * Draw some sort of graph given the specified parameters. The graph
   * should not draw outside of the given region.
   *
   * @param g     the graphics to draw on
   * @param x     the x coordinate of the upper left corner of the graph
   *              area. (The position of the vertical axis)
   * @param y     the y coordinate of the upper left corner of the graph
   * @param width the width of the graph area.
   * @param height the height of the graph
   * @param scale  the scale of the graph, pixel = intensity*scale
   * @param minSize  the minimum size, in bp, that the graph should include
   * @param maxSize  the maximum size, in bp, that the graph should include
   * @param lanes  the lanes to include in the graph.
   */
  public abstract void drawGraph(Graphics g, int x, int y, int width, 
				 int height, int bottom_border,
				 double scale, double minSize, double maxSize,
				 DataList lanes);

  /**
   * Gives the ideal size of the graph. Should return -1 if the graph
   * doesn't care what size it is.
   */
  public abstract int getPreferredWidth();
}
