#!/bin/sh
# Wrapper used by htmldoc.py for calling tace

# Use this for a more diverse server cluster
# Platform-specific setup commands
BIRCH=$1
export BIRCH
BIRCHLIBS=""
export BIRCHLIBS

if [ -z "$BIRCH_PLATFORM" ]
then
    BIRCH_PLATFORM=`grep 'BirchProps.platform' < $BIRCH/local/admin/BIRCH.properties |cut -f2 -d"="`
    export BIRCH_PLATFORM
fi

case $BIRCH_PLATFORM in
  "solaris-sparc")
    BIRCHLIBS=/usr/openwin/lib:/usr/lib:/usr/lib/X11:/usr/dt/lib:$BIRCH/lib-solaris-sparc:$BIRCH/local/lib-solaris-sparc
    ;; 
  "solaris-amd64")
    BIRCHLIBS=/usr/openwin/lib:/usr/lib:/usr/lib/X11:/usr/dt/lib:$BIRCH/lib-solaris-amd64:$BIRCH/local/lib-solaris-amd64
    ;;   
  "linux-intel")
    BIRCHLIBS=$BIRCH/lib-linux-intel:$BIRCH/lib-linux-intel/acedb32:$BIRCH/local/lib-linux-intel   
    ;;
  "linux-x86_64")
    BIRCHLIBS=$BIRCH/local/lib-linux-x86_64:$BIRCH/lib-linux-x86_64/acedb32
    #BIRCHLIBS=$BIRCH/local/lib-linux-x86_64:$BIRCH/lib-linux-x86_64/fc4libs
    ;;
  "osx-x86_64")
    BIRCHLIBS=$BIRCH/lib-osx-x86_64:$BIRCH/local/lib-osx-x86_64
    ;;
  *)
    echo 'tbirchdb.sh: Platform '$BIRCH_PLATFORM 'not supported'
    echo "Can\'t update web documentation pages for local system."
    exit 1
    ;;
esac

#echo BIRCHLIBS $BIRCHLIBS
if [ "$BIRCHLIBS" != "" ]
then
   if [ ! -z "$LD_LIBRARY_PATH" ]
   then
      LD_LIBRARY_PATH="$BIRCHLIBS":"$LD_LIBRARY_PATH"
      export LD_LIBRARY_PATH
   else
      LD_LIBRARY_PATH="$BIRCHLIBS"
      export LD_LIBRARY_PATH
   fi
fi

if [ $BIRCH_PLATFORM = "osx-x86_64" ] 
   then
   DYLD_LIBRARY_PATH="$LD_LIBRARY_PATH"
   export DYLD_LIBRARY_PATH
   echo DYLD_LIBRARY_PATH "$DYLD_LIBRARY_PATH"
fi

#echo LD_LIBRARY_PATH $LD_LIBRARY_PATH

ACEDB=$2
export ACEDB
TACEDIR=$3
BINDIR=$ACEDB/bin
export BINDIR

# Run xace
case $BIRCH_PLATFORM in
  "solaris-sparc")
    ($TACEDIR/tace < $4; $BINDIR/cleanup.sh)&   
    ;; 
  "solaris-amd64")
    ($TACEDIR/tace < $4; $BINDIR/cleanup.sh)&    
    ;;   
  "linux-intel")
    ($BIRCH/lib-linux-intel/acedb32/ld-linux.so.2  --library-path $BIRCHLIBS  $TACEDIR/tace < $4; $BINDIR/cleanup.sh)&    
    ;;
  "linux-x86_64")
    ($BIRCH/lib-linux-x86_64/acedb32/ld-linux.so.2 --library-path $BIRCHLIBS $TACEDIR/tace < $4; $BINDIR/cleanup.sh)&    
    #($TACEDIR/tace < $4; $BINDIR/cleanup.sh)&    
    ;;
  "osx-x86_64")
    ($TACEDIR/tace < $4; $BINDIR/cleanup.sh)&    
    ;;
  *)
    ;;
esac
