#!/bin/sh
# For systems on which there is no PostScript viewer (an increasing
# number of systems), this script runs ps2pdf and then opens the
# PDF viewer to view the PDF file. After viewing, the 
# temporary file is deleted.  
# $ACE_Viewer is the name of the program. 
# $1 is the file for the program to use.

JOBID=$$

# RM_CMD - command to be used for removing files and directories
if [ -f /usr/bin/rm ]
then
   RM_CMD=/usr/bin/rm
else
   if [ -f /bin/rm ]
   then
      RM_CMD=/bin/rm
   else
      RM_CMD=rm
   fi
fi

#Choose a PDF viewer
if [ -z "$ACE_PDF_COMMAND" ] 
   then 
     ACE_PDF_COMMAND=acroread
     export ACE_PDF_COMMAND
fi

case "$BIRCH_PLATFORM" in
     # Looks like OSX does not have ps2pdf as part of the standard install.
     # As well, on OSX, the open
     # command will only open a PostScript file if it has a .ps extension
     # Finally, bash wait doesn't seem to work in bash for OSX, so we
     # use sleep instead.
     "osx-x86_64")
	    echo Opening $1
        cp $1 PStoPDFviewer_$JOBID.ps
        (open PStoPDFviewer_$JOBID.ps; sleep 10; $RM_CMD -f PStoPDFviewer_$JOBID.ps) &
       ;;    
     *)
        echo Converting $1 to PDF...
        tempfile=PStoPDFviewer_$JOBID.pdf
        ps2pdf $1 $tempfile
        ($ACE_PDF_COMMAND $tempfile; wait; $RM_CMD -f $tempfile) &
       ;;
   esac





