#!/bin/sh

# Top directory for your lab database
ACEDB=$BIRCH/labace
export ACEDB
#ACEDB_COMMON=$ACEDB
export ACEDB_COMMON

# Directory to contain the binary database file
DBDIR=$ACEDB/database
export DBDIR

# Directory for executable code specific for your database
# eg. this script
BINDIR=$ACEDB/bin
export BINDIR

#Choose a WYSIWIG editor for viewing ASCII files. 
# Xcoral is a nice alternative. However, due to typical shell weirdness,
# trying to execute external programs (other than xv, for some reason)
#gives getwd errors. So, the fix is to have a shell script in a
#fully qualified path, that does what we want.
if !(! -z "$ACE_XEditor") ACE_XEditor=dtpad
 export ACE_XEditor
ACE_EDIT_COMMAND=$BINDIR/acetextedit
export ACE_EDIT_COMMAND

 
#Choose a graphic viewer
if !(! -z "$ACE_Viewer") ACE_Viewer=xv
 export ACE_Viewer
ACE_VIEW_COMMAND="$BINDIR/aceviewer"
export ACE_VIEW_COMMAND


#Choose a Web browser
#if !(! -z "$ACE_Browser") ACE_Browser=/central/local/netscape7/netscape
 export ACE_Browser
if !(! -z "$ACE_Browser") ACE_Browser=mozilla
 export ACE_Browser
ACE_BROWSER_COMMAND=$BINDIR/aceBrowser
export ACE_BROWSER_COMMAND

#Choose a .pdf viewer
if !(! -z "$ACE_PDF_Viewer") ACE_PDF_Viewer=acroread
 export ACE_PDF_Viewer
ACE_PDF_COMMAND=$BINDIR/acePDFviewer
export ACE_PDF_COMMAND

#Choose a GenBank retrieval command
if !(! -z "$ACEFETCH") ACEFETCH=$BINDIR/acefetch
 export ACEFETCH

# Run xace, and call cleanup.csh to make sure all files
# have correct group membership and permissions.
path="$BINDIR $PATH"


# Use this for a more diverse server cluster
# Platform-specific setup commands
BIRCHLIBS=""
export BIRCHLIBS

case $BIRCH_PLATFORM in
  "solaris-sparc")
    BIRCHLIBS=/usr/openwin/lib:/usr/lib:/usr/lib/X11:/usr/dt/lib:$BIRCH/lib-solaris-sparc:$BIRCH/local/lib-solaris-sparc
    ;; 
  "solaris-amd64")
    BIRCHLIBS=/usr/openwin/lib:/usr/lib:/usr/lib/X11:/usr/dt/lib:$BIRCH/lib-solaris-amd64:$BIRCH/local/lib-solaris-amd64
    ;;   
  "linux-intel")
    BIRCHLIBS=$BIRCH/lib-linux-intel:$BIRCH/lib-linux-intel/acedb32:$BIRCH/local/lib-linux-intel
    GDEFONTS="$BIRCH/lib-linux-intel/gde.fonts/100dpi"
    GDEFONTS=$GDEFONTS','$BIRCH/lib-linux-intel/gde.fonts/misc
    GDEFONTS=$GDEFONTS','$BIRCH/lib-linux-intel/gde.fonts/75dpi    
    ;;
  "linux-x86_64")
    BIRCHLIBS=$BIRCH/local/lib-linux-x86_64:$BIRCH/lib-linux-x86_64/acedb32
    GDEFONTS="$BIRCH/lib-linux-x86_64/gde.fonts/100dpi"
    GDEFONTS=$GDEFONTS','$BIRCH/lib-linux-x86_64/gde.fonts/misc
    GDEFONTS=$GDEFONTS','$BIRCH/lib-linux-x86_64/gde.fonts/75dpi
    ;;
  "osx-x86_64")
    BIRCHLIBS=$BIRCH/lib-osx-x86_64:$BIRCH/local/lib-osx-x86_64
    ;;
  *)
    ;;
esac

export BIRCHLIBS


echo BIRCHLIBS $BIRCHLIBS
if [ ! -z  ${BIRCHLIBS} ]
   then
   if [ "$LD_LIBRARY_PATH" != "" ]
      then
      LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$BIRCHLIBS
   else
      LD_LIBRARY_PATH=$BIRCHLIBS
   fi
   export LD_LIBRARY_PATH   
fi


if [ $BIRCH_PLATFORM = "osx-x86_64" ]
   then
   DYLD_LIBRARY_PATH=$LD_LIBRARY_PATH
   export DYLD_LIBRARY_PATH
   echo DYLD_LIBRARY_PATH $DYLD_LIBRARY_PATH
fi


#echo LD_LIBRARY_PATH $LD_LIBRARY_PATH

   # ------------------------ FONTS ------------------------------
   # See $BIRCH/local/lib-linux-intel/README.fonts

   if [ ! -z "$GDEFONTS" ]
	   then
   #    echo 'Original font settings from xset:'
   #    xset -q
   #   echo GDEFONTS "$GDEFONTS"

      # FOR TESTING PURPOSES ONLY:
      # Remove all fonts from fontpath, and set ONLY the fonts we think we need
      #xset fp- /home/psgendb/.gnome2/share/cursor-fonts,tcp/localhost:7100,/home/psgendb/.gnome2/share/fonts
      # Set $GDEFONTS to fontpath
      #xset fp= $GDEFONTS

      # Append $GDEFONTS to fontpath. Probably the safest choice.
      xset +fp $GDEFONTS
      # Prepend $GDEFONTS to fontpath
      #xset fp+ $GDEFONTS

      # Show current X settings, including fontpath
   #   echo 'Revised font settings from xset:'
   #   xset -q   
   fi

# Run xace
case $BIRCH_PLATFORM in
  "solaris-sparc")
    (xace; $BINDIR/cleanup.sh)&   
    ;; 
  "solaris-amd64")
    (xace; $BINDIR/cleanup.sh)&    
    ;;   
  "linux-intel")
    ($BIRCH/lib-linux-intel/acedb32/ld-linux.so.2 $BIRCH/bin-linux-intel/xace; $BINDIR/cleanup.sh)&    
    ;;
  "linux-x86_64")
    ($BIRCH/lib-linux-x86_64/acedb32/ld-linux.so.2 $BIRCH/bin-linux-x86_64/xace; $BINDIR/cleanup.sh)&    
    ;;
  "osx-x86_64")
    (xace; $BINDIR/cleanup.sh)&    
    ;;
  *)
    ;;
esac
