#!/bin/sh

# Find out the following platform parameters:
#   operating system
#   processor family

# Operating system
OS=`uname -s | tr -s '[:upper:]' '[:lower:]'`
case $OS in
   sunos)
     OS=solaris
     ;;
  linux) 
     OS=linux
    ;;
  *)
    OS=linux  
    ;; 
esac

# Processor family
PROC=`uname -p | tr -s '[:upper:]' '[:lower:]'`
case $PROC in
   sparc)
     PROC=sparc
     ;;
   i686)
     PROC=intel
     ;;
   *)
     PROC=intel 
     ;; 
esac


# Map the result to supported BIRCH platforms
if [ "$OS" = "solaris" ]
   then
   case $PROC in
      sparc)
       PLATFORM='solaris-sparc'
	;;
     intel)
      PLATFORM='solaris-amd64'
       ;;
     *)
      PLATFORM='solaris-sparc' 
      ;; 
   esac
elif [ "$OS" = "linux" ]
     then
      case $PROC in
	intel)
	 PLATFORM='linux-intel'
	  ;;
       *)
	 PLATFORM='linux-intel' 
	 ;; 
      esac
else
   PLATFORM='linux-intel'  
fi

echo $PLATFORM


