#!/bin/sh

#Version   5/26/10
# Launch viewers for phylogenetic tree data or send output to files
# For use by programs that generate tree output eg. bldna, blprotein, blmarker etc.
#
#Synopsis: bltreeoutput.sh [-e|-d|-f] outtree outfile outname 


#Convert arguments to variables
WHATTODO=$1
OUTTREE=$2
OUTFILE=$3
OUTNAME=$4
JOBID=$$


# RM_CMD - command to be used for removing files and directories
if [ -f /usr/bin/rm ]
then
   RM_CMD=/usr/bin/rm
else
   if [ -f /bin/rm ]
   then
      RM_CMD=/bin/rm
   else
      RM_CMD=rm
   fi
fi


# Special code for text editors used by GDE and scripts called by GDE
# Nedit crashes in some Linux systems due to libraries set in BIRCHLIBS.
# nedit_wrapper unsets LD_LIBRARY_PATH before calling nedit.
# gedit opens all files in a single window. gedit_wrapper.sh forces
# gedit to open each file in different window.
# choose_edit_wrapper.sh returns the name of the wrapper to use
# for each editor, or just returns GDE_TEXTEDIT if there is no
# wrapper.
GDE_TEXTEDIT=`choose_edit_wrapper.sh`
export GDE_TEXTEDIT
 
case $WHATTODO in
   -e) # output to tree editor
      ($GDE_TEXTEDIT $OUTFILE; $RM_CMD $OUTFILE)&
      (atv $OUTTREE)&
      ($GDE_TEXTEDIT $OUTTREE)& 
      (python $birch/script/tree2flat.py $OUTTREE $JOBID.flat; bltree $JOBID.flat; $RM_CMD $OUTTREE $JOBID.flat)& 
        if [  -e $OUTTREE.alltrees ]
        then
	(python $birch/script/tree2flat.py $OUTTREE.alltrees $JOBID.alltrees.flat; bltree $JOBID.alltrees.flat; $RM_CMD $JOBID.alltrees.flat)& 	
	($GDE_TEXTEDIT $OUTTREE.alltrees; $RM_CMD $OUTTREE.alltrees)&
        fi
      ;;
   -d) # output to drawing program
      ($GDE_TEXTEDIT $OUTFILE; $RM_CMD $OUTFILE)&
      (drawtree.csh $OUTTREE yes f 0 360 IE 360 reg $DAT/Phylip/font1 0.333 l $JOBID.plotfile; $GDE_PSVIEW $JOBID.plotfile; $RM_CMD $JOBID.plotfile)&
      ($GDE_TEXTEDIT $OUTTREE) &
      (python $birch/script/tree2flat.py $OUTTREE $JOBID.flat; bltree $JOBID.flat; $RM_CMD $OUTTREE $JOBID.flat)& 
      if [  -e $OUTTREE.alltrees ]
      then
	(python $birch/script/tree2flat.py $OUTTREE.alltrees $JOBID.alltrees.flat; bltree $JOBID.alltrees.flat; $RM_CMD $JOBID.alltrees.flat)& 
	($GDE_TEXTEDIT $OUTTREE.alltrees; $RM_CMD $OUTTREE.alltrees)&
      fi
      ;;
   -f) #output to files
      mv $OUTFILE $OUTNAME.outfile
      mv $OUTTREE $OUTNAME.treefile 
      if [ -e $OUTTREE.alltrees ]
      then
         mv $OUTTREE.alltrees $OUTNAME.alltrees.treefile
      fi
      ;;
esac
