#!/bin/csh

#Version  4/23/98
#Synopsis: consensus.csh infile program width strand printbest outfile

#Convert arguments to variables
set INFILE       = $1
set PROGRAM      = $2
set WIDTH        = $3
set STRAND       = $4
set PRINTBEST    = $5
set OUTFILE      = $6

# Make a temporary directory to run the program in 
set TEMPDIR = CONSENSUS.$$
mkdir $TEMPDIR
cp $INFILE $TEMPDIR
cp $INFILE.alphabet $TEMPDIR
cd $TEMPDIR

#-------- run consensus  -----------
switch ($PROGRAM)
   case "consensus":
     consensus -a $INFILE.alphabet $STRAND -L$WIDTH -pf $PRINTBEST < $INFILE > $OUTFILE
   breaksw
   case "wconsensus":
     if ($STRAND == "-c3") set STRAND = ""
     consensus -a $INFILE.alphabet $STRAND -pf $PRINTBEST < $INFILE > $OUTFILE
   breaksw
endsw



mv  -f $OUTFILE ../$OUTFILE
cd ..

/usr/bin/rm -r $TEMPDIR






