"""
June 6th 2010, Dale Hamel, University of Manitoba
 Description: Determines whether the system is OS X or linux, and creates
 the appropriate launcher on the user's desktop.

 Synopsis: python makelauncher.py
 Notes: To create the apple launcher appropriately, there MUST be a template
 application "biolegato.app" in the current working directory in a folder
 called "osx_launcher"

@modified: June 6 2010
@author: Dale Hamel
@contact: umhameld@cc.umanitoba.ca

"""



import os
import sys
blib = os.environ.get("BIRCHLIB")
sys.path.append(blib)

from birchlib import Birchmod

PROGRAM = "makelauncher.py: "
USAGE = "\n\tUSAGE: makelauncher.py"

PLATFORM = os.environ.get("BIRCH_PLATFORM")


BM = Birchmod(PROGRAM, USAGE)

def get_desktop():
    """
        Returns the location of the current user's desktop directory
        by reading the environment variable "HOME", and assuming that there
        is a "HOME/Desktop" directory
        """
    home_dir = os.environ.get("HOME")
    
    if (os.path.exists(home_dir)):
        desktop_dir = home_dir + "/Desktop"
        
        if (os.path.exists(desktop_dir)):
            print(PROGRAM + "Found desktop at: " + desktop_dir)

        else:
            desktop_dir = None
    
    return desktop_dir


def make_gnome_launcher(desktop_dir):
    """
        Creates a launcher of the form biolegato.desktop for use on
        linux desktops such as GNOME (v2+) and KDE (v3.5+). May also work
        on other desktops such as qt, etc, but not yet tested

        @desktop_dir: the location of the user's desktop directory,
        where the launcher will be placed

        """

        
    birch_dir = os.environ.get("BIRCH")
    
    launcher_str = "[Desktop Entry]\nName=Biolegato\nIcon=" + birch_dir + "/public_html/smallbirch.gif\nType=Application\nExec=bash -lc birch\nStartupNotify=true\nTerminal=false\n\n"
    
    file_name = birch_dir + "/admin/birch.desktop"
    
    if (birch_dir != None):
        write_launcher(file_name, launcher_str)
        os.chdir(desktop_dir)
        os.system("ln -s "+file_name+" .")
        print("Made symbolic link to launcher on desktop")


#def make_apple_launcher(desktop_dir):
#       """
#       ***DEPRECIATED!***
#       Makes a simple double-clickable wrapper script for biolegato
#       @desktop_dir:the location of the user's desktop directory,
#       where the launcher will be placed
#
#       """

    
#    file_name=desktop_dir+"/birch.command"
#    launcher_str="#!/bin/bash\n\nbiolegato"
    
#    write_launcher(file_name)


def make_apple_launcher(desktop_dir):
    """
        Makes a launcher application for OS X (tested on 10.5.8) of the format
        biolegato.app. The launcher is just a wrapper for an apple script
        that calls the system biolegato, and should use system paths.

        The this method copies a template launcher called "biolegato.app"
        to the desktop that is assumed to be in the current working directory
        in adirectory called "osx_launcher", if this changes then this method
        will need to be updated.

        Once the launcher is copied, all the contents of the BIRCH directory
        specified by the environment variable $BIRCH will be symbolically
        linked into the applications resource directory under:
        
        ~/biolegato.app/Contents/Resources"

        @desktop_dir: the location of the user's desktop directory,
        where the launcher will be placed
        """

    base_dir = os.getcwd()
    birch_dir = os.environ.get("BIRCH")
    curr_dir = base_dir


    os.chdir(birch_dir + "/script/osx_launcher")
    curr_dir = os.getcwd()
    print(PROGRAM + "Changed directory to: " + curr_dir)

    os.system("cp -r -p -f biolegato.app " + birch_dir+"/admin")
    os.chdir(desktop_dir)
    os.system("ln -s "+birch_dir+"/admin/biolegato.app .")
    print(PROGRAM + "Made symbolic link to launcher on desktop")

        
    os.chdir(birch_dir+"/admin/biolegato.app/Contents/Resources")
    curr_dir = os.getcwd()
    print(PROGRAM + "Changed directory to: " + curr_dir)

    os.system("ln -s " + birch_dir + "/* .")
    print(PROGRAM + "Made symbolic links:\n")
    os.system("ls -l | grep lrwxr-xr-x ")
        
       
    
def write_launcher(file_name, launcher_str):
    """
        Writes the contents of launcher_str to a file specified by
        file_name, and makes that file executable

        @file_name: the fully qualified name (including path) of the file to write.
        @launcher_str: the contents to write to the file

        """
        
    
    print(PROGRAM + "Writing contents to file: " + file_name)
        
    out_file = open(file_name, 'w')
    out_file.write(launcher_str)
    out_file.close
        
        
    print(PROGRAM + "Setting file permissions to executable...")
    os.chmod(file_name, 0777)

def make_win_launcher():
    windir=os.environ.get("HOMEDRIVE")+os.environ.get("HOMEPATH")
    os.chdir(windir+"/Desktop")
    print(os.getcwd())
    
    
    
    birch_dir=os.environ.get("BIRCH")
    biolegato=birch_dir+"/java/bioLegato.0.7.0/biolegato.bat"
    birch_icon=birch_dir+"/public_html/smallbirch.ico"
    
    cygwin_bat="/cygwin.bat"
    
    os.system("mkshortcut -n bioLegato -i "+birch_icon+" "+biolegato)
    os.system("mkshortcut -n birchTerm "+cygwin_bat)

def main():
    desktop_dir = get_desktop()
    
    if (desktop_dir != None):
                
        #This assumes either OSX or using gnome/kde, if this changes
        #this switch will need to be updated
        if (not PLATFORM == "osx-x86_64" and  PLATFORM.find("win")<0):
            make_gnome_launcher(desktop_dir)
            

        elif(PLATFORM=="osx-x86_64"):# working in osx

            make_apple_launcher(desktop_dir)
            
    elif(PLATFORM=="winxp-32"):
        make_win_launcher()
        
    else:
        exit()

    print(PROGRAM + "Completed execution normally.")

if (BM.documentor() or "-test" in sys.argv):
    pass
else:
    main()

