#!/bin/csh

#Version  8/28/2007
# Run distance programs as a command
#Synopsis: distance.csh infile utree ufn replicates jumble jseed numjum method \
#           negbranch outgroup subrep global termout printdata outfile treefile

#  It is important that when running with the USERTREE option, 
#  the usertree should come from the same program that is currently
#  being run. eg. don't use a kitsch-generated tree as input to fitch.

#Convert arguments to variables
set INFILE        = $1
set UTREE         = $2
set UFN           = $3
set REPLICATES    = $4
set JUMBLE        = $5
set JSEED         = $6
set NUMJUM        = $7
set METHOD        = $8
set NEGBRANCH     = $9
set OUTGROUP      = $10
set SUBREP        = $11
set GLOBAL        = $12
set TERMOUT       = $13
set PRINTDATA     = $14
set OUTFILE       = $15
set TREEFILE      = $16

# RM_CMD - command to be used for removing files and directories
if (-e /usr/bin/rm) then
   set RM_CMD = /usr/bin/rm
else
   if (-e /bin/rm) then
      set RM_CMD = /bin/rm
   else
      set RM_CMD = rm
   endif
endif

# Remember where we started
set STARTDIR = $PWD
echo 'Starting Directory: ' $STARTDIR

#----------------- generate keyboard input to send to program -----

# Make a temporary directory in which to run the program
set TEMPDIR = DISTANCE.$$
mkdir $TEMPDIR
cp $INFILE $TEMPDIR/infile
if ($UTREE == 'y') then
   # Make sure that treefile begins with number of trees on first
   # line of file. If first line in file has parentheses, the
   # number must be added.
   if (`head -1 $UFN | grep '('` != "" ) then
      grep ';' $UFN | wc -l >> $TEMPDIR/infile
   endif
   cat $UFN >> $TEMPDIR/infile
endif

cd $TEMPDIR

# Choose program and set program-specific parameters
if (($METHOD == "f") || ($METHOD == "k")) then

   if ($UTREE == 'y') then
      echo 'u' >> PARAMFILE
   endif

   if ($METHOD == 'f') then
      set PROGRAM = 'fitch'
      # Global rearrangements
      if ($GLOBAL == 'y') echo 'g' >> PARAMFILE

      # Outgroup
      set FIRSTLINE = `head -1 infile`
      set NUMSEQ = $FIRSTLINE[1]
      if (($OUTGROUP > 1) && ($OUTGROUP <= $NUMSEQ)) then
         echo o >> PARAMFILE
         echo $OUTGROUP >> PARAMFILE
      else
         set OUTGROUP = 1
      endif

   else
      set PROGRAM = 'kitsch'
   endif

   # Negative branch lengths allowed?
   if ($NEGBRANCH == 'y') echo '-' >> PARAMFILE

else
    set PROGRAM = 'neighbor'
    # For Neighbor Joining, choose NJ or UPGMA
    if ($METHOD == "u") echo 'n' >> PARAMFILE
    if ($UTREE == 'y') echo '>>> USERTREE option NOT AVAILABLE in NEIGHBOR' >> MSGFILE
endif

# Subreplicates?
if ($SUBREP == 's') echo 's' >> PARAMFILE

# if bootstrapping, REPLICATES will be > 1
if ($REPLICATES > 1) then
   echo m >> PARAMFILE
   echo $REPLICATES >> PARAMFILE
endif

# Jumble
if ($JUMBLE == 'y') then 
   # Random seeds, odd, of the form 4n + 1
   @ tempjseed = ( ( ( $JSEED / 4 ) * 4 ) + 1 )

   echo JUMBLING SEQUENCE ORDER $NUMJUM ITERATIONS, SEED\=$tempjseed >> MSGFILE
   echo  j >> PARAMFILE
   echo $tempjseed  >> PARAMFILE
   echo $NUMJUM >> PARAMFILE
endif
	
# Should sequence data be printed?
if ($PRINTDATA ==  y) echo 1 >> PARAMFILE

# When resampling or jumbling, turn off printing trees to outfile
if (($REPLICATES > 1)  || ($JUMBLE == 'y')) then
   echo 3 >> PARAMFILE
endif

#accept current settings and do the analysis
echo y  >> PARAMFILE

#-------- Run distance program -----------

echo `time nice $PROGRAM < PARAMFILE > $TERMOUT` > TIMEFILE
echo Execution times on `hostname`\: `cat TIMEFILE` >> outfile


#----------- Return results to calling directory----------------
# When using resampling or jumbling, filter the treefile through
# consense to generate an unrooted consensus tree.
if (($REPLICATES > 1)  || ($NUMJUM > 1)) then
	echo " " >> outfile
	echo '-------------------------------------------' >> outfile
        echo '* * * * * * * * * *  C O N S E S U S   T R E E  * * * * * * * *' >> outfile
        # FITCH requires a rooted tree. KITSCH requires an unrooted tree.
        if ($PROGRAM == 'fitch') then
	   consense.csh treefile $OUTGROUP y outfile.consense $STARTDIR/$TREEFILE
        else
	   consense.csh treefile $OUTGROUP n outfile.consense $STARTDIR/$TREEFILE
        endif
        echo '' >> outfile.consense
        echo '' >> outfile.consense
        echo '>>>> TO GENERATE BRANCH LENGTHS' >> outfile.consense
        if ($PROGRAM == 'fitch') then
           echo '>>>> USE TREE FILE AS INPUT FOR fitch' >> outfile.consense
        else
           echo '>>>> USE TREE FILE AS INPUT FOR kitsch' >> outfile.consense
        endif
        echo '>>>> USING THE USERTREE OPTION' >> outfile.consense

	cat MSGFILE outfile outfile.consense  > $STARTDIR/$OUTFILE
else
        mv treefile $STARTDIR/$TREEFILE
	cat MSGFILE outfile  > $STARTDIR/$OUTFILE
endif

cd ..
$RM_CMD -r $TEMPDIR







