#!/bin/csh

#Version   3/17/11
# Run drawgram as a command
#Synopsis: drawgram.csh treefile torient tstyle uselen langle dbratio ldratio
#                       fontfile charheight ancestnode outformat outfile

#Convert arguments to variables
set TREEFILE    = $1
set TORIENT     = $2
set TSTYLE      = $3
set USELEN      = $4
set LANGLE      = $5
set DBRATIO     = $6
set LDRATIO     = $7
set FONTFILE    = $8
set CHARHEIGHT  = $9
set ANCESTNODE  = $10
set OUTFORMAT   = $11
set OUTFILE     = $12

# RM_CMD - command to be used for removing files and directories
if (-e /usr/bin/rm) then
   set RM_CMD = /usr/bin/rm
else
   if (-e /bin/rm) then
      set RM_CMD = /bin/rm
   else
      set RM_CMD = rm
   endif
endif

# Make a temporary directory in which to run the program
set TEMPDIR = DRAWTREE.$$
mkdir $TEMPDIR
cp $TREEFILE $TEMPDIR/intree
cd $TEMPDIR

#----------------- generate keyboard input to send to program -----
if ($OUTFORMAT == "l" | $OUTFORMAT == "m" | $OUTFORMAT == "j" | $OUTFORMAT == "f" | \
    $OUTFORMAT == "a" | $OUTFORMAT == "z" | $OUTFORMAT == "p" | $OUTFORMAT == "x" | \
    $OUTFORMAT == "v" | $OUTFORMAT == "e" | $OUTFORMAT == "c" | $OUTFORMAT == "t" | \
    $OUTFORMAT == "o" | $OUTFORMAT == "b" ) then
    # choose an output file format
    echo  P >> PARAMFILE 
    echo $OUTFORMAT >> PARAMFILE 

    # some output formats require additional specifications
    switch ($OUTFORMAT)
      case "j":     # Hewlett Packard Laserjet
	echo n >> PARAMFILE 
	echo 2 >> PARAMFILE         #Resolution 150 dpi
	breaksw
      case "p":     # PC Paintbrush PCX format
	echo n >> PARAMFILE 
	echo 3 >> PARAMFILE        #Resolution VGA 1024 x 768
	breaksw
      case "x":     #X11 bitmap
	echo n >> PARAMFILE
	echo 1024 >> PARAMFILE      #X resolution
	echo 512  >> PARAMFILE       #Y resolution
	breaksw
      default :      # all others, no extra specs. needed         
	breaksw
    endsw
endif

# Turn off X-windows display
echo v >> PARAMFILE 
echo n >> PARAMFILE 

# Tree parameters
if ($TORIENT == v) echo h >> PARAMFILE 

echo s >> PARAMFILE 
echo $TSTYLE >> PARAMFILE 

if ($USELEN == no) echo b >> PARAMFILE 

echo l >> PARAMFILE 
echo $LANGLE >> PARAMFILE 

echo d >> PARAMFILE 
echo $DBRATIO >> PARAMFILE 

echo t >> PARAMFILE 
echo $LDRATIO >> PARAMFILE 

echo c >> PARAMFILE 
echo $CHARHEIGHT >> PARAMFILE 

echo a >> PARAMFILE 
echo $ANCESTNODE >> PARAMFILE 

echo y >> PARAMFILE    #accept current settings and write plotfile

#---------------------  Run Drawgram ----------------------

# - - - - - - LD_LIBRARY_PATH - - - - - - - - - - -
# On Linux, the Athena Widget kit is not part of the standard install. 
# drawtree and drawgram both need libXaw.7.so. So that has been
# added to lib-linux-intel and lib-linux-x86_64, and we need to set
# LD_LIBRARY_PATH so the script can find it.
# Use this for a more diverse server cluster
# Platform-specific setup commands
setenv BIRCHLIBS  ""
switch ($BIRCH_PLATFORM)
  case "solaris-sparc":
    setenv BIRCHLIBS "/usr/openwin/lib:/usr/lib:/usr/lib/X11:/usr/dt/lib:$BIRCH/lib-solaris-sparc:$BIRCH/local/lib-solaris-sparc"
    breaksw 
  case "solaris-amd64":
    setenv BIRCHLIBS "/usr/openwin/lib:/usr/lib:/usr/lib/X11:/usr/dt/lib:$BIRCH/lib-solaris-amd64:$BIRCH/local/lib-solaris-amd64"
    breaksw   
  case "linux-intel":
    setenv BIRCHLIBS $BIRCH/lib-linux-intel:$BIRCH/lib-linux-intel/openwin/lib:$BIRCH/local/lib-linux-intel
    breaksw
  case "linux-x86_64":
    setenv BIRCHLIBS $BIRCH/lib-linux-x86_64:$BIRCH/lib-linux-x86_64/openwin/lib:$BIRCH/local/lib-linux-x86_64
    breaksw
  case "osx-x86_64":
    setenv BIRCHLIBS $BIRCH/lib-osx-x86_64:$BIRCH/local/lib-osx-x86_64
    breaksw
  default:
    breaksw
endsw

echo BIRCHLIBS $BIRCHLIBS
if ( "$BIRCHLIBS" != "" ) then
   if ${?LD_LIBRARY_PATH} then
      setenv LD_LIBRARY_PATH "$LD_LIBRARY_PATH":"$BIRCHLIBS"
   else
      setenv LD_LIBRARY_PATH "$BIRCHLIBS"
   endif
endif

#echo drawgram.csh: LD_LIBRARY_PATH= $LD_LIBRARY_PATH
cp $FONTFILE fontfile
nice +10 drawgram < PARAMFILE

mv plotfile ../$OUTFILE
cd ..
$RM_CMD -rf $TEMPDIR



