#!/bin/csh

#Version   3/17/11
# Run drawtree as a command
#Synopsis: drawtree.csh treefile uselen lableorient lableangle rotation  
#                       iterate angleofarc regularization charheight outformat outfile 

#Convert arguments to variables
set TREEFILE       = $1
set USELEN         = $2
set LABLEORIENT    = $3
set LABLEANGLE     = $4
set ROTATION       = $5
set ITERATE        = $6
set ANGLEOFARC     = $7
set REGULARIZATION = $8
set FONTFILE       = $9
set CHARHEIGHT     = $10
set OUTFORMAT      = $11
set OUTFILE        = $12

# RM_CMD - command to be used for removing files and directories
if (-e /usr/bin/rm) then
   set RM_CMD = /usr/bin/rm
else
   if (-e /bin/rm) then
      set RM_CMD = /bin/rm
   else
      set RM_CMD = rm
   endif
endif

# Make a temporary directory in which to run the program
set TEMPDIR = DRAWGRAM.$$
mkdir $TEMPDIR
cp $TREEFILE $TEMPDIR/intree
cd $TEMPDIR

#----------------- generate keyboard input to send to program -----
if ($OUTFORMAT == "l" | $OUTFORMAT == "m" | $OUTFORMAT == "j" | $OUTFORMAT == "f" | \
    $OUTFORMAT == "a" | $OUTFORMAT == "z" | $OUTFORMAT == "p" | $OUTFORMAT == "x" | \
    $OUTFORMAT == "v" | $OUTFORMAT == "e" | $OUTFORMAT == "c" | $OUTFORMAT == "t" | \
    $OUTFORMAT == "o" | $OUTFORMAT == "b" ) then
    # choose an output file format
    echo  P >> PARAMFILE 
    echo $OUTFORMAT >> PARAMFILE 

    # some output formats require additional specifications
    switch ($OUTFORMAT)
      case "j":     # Hewlett Packard Laserjet
	echo n >> PARAMFILE 
	echo 2 >> PARAMFILE         #Resolution 150 dpi
	breaksw
      case "p":     # PC Paintbrush PCX format
	echo n >> PARAMFILE 
	echo 3 >> PARAMFILE        #Resolution VGA 1024 x 768
	breaksw
      case "x":     #X11 bitmap
	echo n >> PARAMFILE
	echo 1024 >> PARAMFILE      #X resolution
	echo 512  >> PARAMFILE       #Y resolution
	breaksw
      default :      # all others, no extra specs. needed         
	breaksw
    endsw
endif

# Turn off X-windows display
echo v >> PARAMFILE 
echo n >> PARAMFILE 

# Tree parameters

if ($USELEN == "no") echo b >> PARAMFILE 

echo l >> PARAMFILE
echo $LABLEORIENT >> PARAMFILE 
if ($LABLEORIENT == f)  echo $LABLEANGLE >> PARAMFILE 

echo r >> PARAMFILE 
echo $ROTATION >> PARAMFILE 

# Iterate - default is Equal-Daylight; do nothing
if ($ITERATE == "In") then
  echo i >> PARAMFILE                    
else if ($ITERATE == "No") then
  echo i >> PARAMFILE 
  echo i >> PARAMFILE 
  echo $ANGLEOFARC >> PARAMFILE
  if ($REGULARIZATION == "reg") echo g >> PARAMFILE 
endif

echo c >> PARAMFILE 
echo $CHARHEIGHT >> PARAMFILE 

echo y >> PARAMFILE     #accept current settings and write plotfile

#---------------------  Run Drawtree ----------------------

# - - - - - - LD_LIBRARY_PATH - - - - - - - - - - -
# On Linux, the Athena Widget kit is not part of the standard install. 
# drawtree and drawgram both need libXaw.7.so. So that has been
# added to lib-linux-intel and lib-linux-x86_64, and we need to set
# LD_LIBRARY_PATH so the script can find it.
# Use this for a more diverse server cluster
# Platform-specific setup commands
setenv BIRCHLIBS  ""
switch ($BIRCH_PLATFORM)
  case "solaris-sparc":
    setenv BIRCHLIBS "/usr/openwin/lib:/usr/lib:/usr/lib/X11:/usr/dt/lib:$BIRCH/lib-solaris-sparc:$BIRCH/local/lib-solaris-sparc"
    breaksw 
  case "solaris-amd64":
    setenv BIRCHLIBS "/usr/openwin/lib:/usr/lib:/usr/lib/X11:/usr/dt/lib:$BIRCH/lib-solaris-amd64:$BIRCH/local/lib-solaris-amd64"
    breaksw   
  case "linux-intel":
    setenv BIRCHLIBS $BIRCH/lib-linux-intel:$BIRCH/lib-linux-intel/openwin/lib:$BIRCH/local/lib-linux-intel
    breaksw
  case "linux-x86_64":
    setenv BIRCHLIBS $BIRCH/lib-linux-x86_64:$BIRCH/lib-linux-x86_64/openwin/lib:$BIRCH/local/lib-linux-x86_64
    breaksw
  case "osx-x86_64":
    setenv BIRCHLIBS $BIRCH/lib-osx-x86_64:$BIRCH/local/lib-osx-x86_64
    breaksw
  default:
    breaksw
endsw

echo BIRCHLIBS $BIRCHLIBS
if ( "$BIRCHLIBS" != "" ) then
   if ${?LD_LIBRARY_PATH} then
      setenv LD_LIBRARY_PATH "$LD_LIBRARY_PATH":"$BIRCHLIBS"
   else
      setenv LD_LIBRARY_PATH "$BIRCHLIBS"
   endif
endif

#echo drawgram.csh: LD_LIBRARY_PATH= $LD_LIBRARY_PATH


cp $FONTFILE fontfile
nice +10 drawtree < PARAMFILE

mv plotfile ../$OUTFILE
cd ..
$RM_CMD -rf $TEMPDIR





