#!/bin/csh

#Version  2/17/2003
#Synopsis: fastDNAmlrun.csh infile bstrap bseed bnum outname [rls]

set INFILE    = $1
set BSTRAP    = $2
set BSEED     = $3
set BNUM      = $4
set ONAME     = $5
set EXECUTION = $6
set JOBID     = $$
set OUTFILE   = $ONAME.outfile

# RM_CMD - command to be used for removing files and directories
if (-e /usr/bin/rm) then
   set RM_CMD = /usr/bin/rm
else
   if (-e /bin/rm) then
      set RM_CMD = /bin/rm
   else
      set RM_CMD = rm
   endif
endif


switch ($EXECUTION) 
   case "r":
      #Run remotely
      set RHOST = `choosehost`
      set RUSER = `whoami`
      echo Copying $INFILE to $RUSER@$RHOST\:$JOBID.infile
      rcp $INFILE $RUSER@$RHOST\:$JOBID.infile
      echo Running fastDNAml remotely on $RHOST...
      rsh $RHOST -l $RUSER fastDNAmlrun.csh $JOBID.infile $BSTRAP $BSEED $BNUM\
             $JOBID l
      echo Copying output files to local host
      rcp $RUSER@$RHOST\:$JOBID.outfile $ONAME.outfile
      rcp $RUSER@$RHOST\:$JOBID.treefile $ONAME.treefile
      rcp $RUSER@$RHOST\:$JOBID.raw.treefile $ONAME.raw.treefile
      echo Removing temporary files on remote host
      rsh $RHOST -l $RUSER $RM_CMD "$JOBID.*"
      breaksw
   case "l":
      #Run locally
      mkdir $INFILE.dir.$JOBID
      cp $INFILE $INFILE.dir.$JOBID
      cd $INFILE.dir.$JOBID
      if ($BSTRAP == 'y') then
         echo fastDNAml: $BNUM BOOTSTRAPPED REPLICATES, RANDOM SEED: $BSEED > $OUTFILE
         echo '' >> $OUTFILE
         echo '>>>> SEE BOTTOM OF PRINTOUT FOR CONSENSUS TREE' >> $OUTFILE
         echo '' >> $OUTFILE
         echo `time nice fastDNAml_boot -seed $BSEED -boots $BNUM $INFILE 1` > $INFILE.time
         foreach file (*.out)
           cat $file >> $OUTFILE
           $RM_CMD $file
           end
         echo Execution times on `hostname`\: `cat $INFILE.time` >> $OUTFILE
         echo '' >> $OUTFILE
         echo '* * * * * * * * * *  C O N S E S U S   T R E E  * * * * * * * *' >> $OUTFILE
         
         # For each treefile, delete comments, blanks and quotes.
         # Combine into a single file. 
         # Generate a consensus tree using CONSENSE
         foreach file (*.tree)
           sed -e "s/\[.*\]//" < $file | tr -d " " | tr -d "'" >> raw.treefile
           end
         cp raw.treefile ../$ONAME.raw.treefile
         consense.csh raw.treefile 1 u $OUTFILE.temp treefile
         cat $OUTFILE.temp >> $OUTFILE
         echo '' >> $OUTFILE
         echo '' >> $OUTFILE
         echo '>>>> TO GENERATE BRANCH LENGTHS' >> $OUTFILE
         echo '>>>> USE TREE FILE AS INPUT FOR FASTDNAML OR OTHER PROGRAM' >> $OUTFILE
         echo '>>>> USING THE USERTREE OPTION' >> $OUTFILE
         mv treefile ../$ONAME.treefile
         mv $OUTFILE ..
      else
         echo `time nice fastDNAml < $INFILE > $OUTFILE` > $INFILE.time
         echo Execution times on `hostname`\: `cat $INFILE.time` >> $OUTFILE
         sed "s/\[.*\] //" treefile.* | tr -d " " | tr -d "'" > ../$ONAME.treefile
         mv $OUTFILE ..
      endif

      cd ..
      $RM_CMD -r $INFILE.dir.$JOBID
      breaksw
endsw
