#!/usr/local/bin/perl -n 

BEGIN{$/ = "\n>";}

$dir = ".";
chomp;
$_ =~ s/^>//;
($name, $stuff) = /^\s*(\S+).*?\n(\S+)/;
if(not $name){
  warn "Sequence #$. is unnamed, ignoring\n";
  next;
} 
if(not $stuff){
  warn "Sequence $name is empty\n";
}

$name =~ s/^.*\|([A-Z]+\d+)(?:\.\d+)(?:\||$)/$1/;

if(-e "$dir/$name.fas"){
  warn "Sequence $dir/$name.fas already exists.  Remove it in order for the new file to be written\n";
  next;
}
open(OUT, ">$dir/$name.fas") 
  or die "Cannot open $name for writing: $!\n";
print OUT ">$_";
close(OUT);
