
#!/usr/local/bin/python
"""
September 1, 2010, Dr. Brian Fristensky, University of Manitoba

 Description: Convert a GDE flat file to a file of tokens.
 The input file contains a single nonblank
 string on each line.

 Synopsis: list2flat.py infile outfile

 Files: infile      GDE flat file, containing a comma separated
                    list of tokens

        outfile     file of tokens
        
@modified: May 26 2010
@author: Dale Hamel
@contact: umhameld@cc.umanitoba.ca
"""
import sys
import os.path
import sys

blib = os.environ.get("BIRCHPYLIB")
sys.path.append(blib)

from birchlib import Birchmod
from birchlib import Argument

PROGRAM = "flat2list.py: "
USAGE = "\n\t USAGE: flat2list.py infile outfile"
BM = Birchmod(PROGRAM, USAGE)

class Parameters:
	
    def __init__(self):
        """
     		Initializes arguments:
     			IFN=""
     			OFN=""
     		Then calls read_args() to fill in their values from command line
     		"""
        self.IFN = ""
        self.OFN = ""
        self.read_args()
	
    def read_args(self):
        """
    		Reads command line arguments into a Paramter object
		"""
        infile = Argument("", str, BM)
        outfile = Argument("", str, BM)
		
        infile.set_position(1)
        outfile.set_position(2)
		
        try:
            self.IFN = infile.fetch()
            self.OFN = outfile.fetch()
        except ValueError:
            BM.printusage()

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

def get_gde_list(FN):
    """
    Read in old and new strings, striping 
    leading and trailing whitespace, including
    newline characters.
    """	
    try:
    	in_file = open(FN, 'r')
    except:
    	BM.file_error(FN)
    # skip name line
    line = in_file.readline()
    
    # GDE wraps the flat file with newlines every 60
    # characters. 
    # Next, we have to delete the newlines to turn the entire
    # file into a single long string called bigline
    bigline = "" 
    
    for line in in_file:
        line = line.strip()
        bigline = bigline + line
	  
  
    # parse the string as a comma separated list
    lst = bigline.split(',')

    in_file.close()
    return lst

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

def writenamefile(OUTFILE, lst):
    """
    Write the list as a single line of comma-separated values
    """	
    if len(lst) > 0:
        for i in range(0, len(lst)):
            line = lst[i].strip()
            if line != "":
                line = line + '\n'
                OUTFILE.write(line)

    
#======================== MAIN PROCEDURE ==========================

#---------- Set global variables
def main():
    """
    	Called when not in documentation mode.
    	"""
    P = Parameters()
	
    OUTFILE = open(P.OFN, 'w')
	
    if os.path.exists(P.IFN):
	
        # Read in GDE flat file
        id_list = get_gde_list(P.IFN)
	
        #Write the list with one token per line
        writenamefile(OUTFILE, id_list)
	
    OUTFILE.close()
	
    BM.exit_success()

if (BM.documentor() or "-test" in sys.argv):
    pass
else:
    main()
