"""
Aug 26th 2010, Dale Hamel, University of Manitoba
 Description: Determines whether the system is OS X or linux, and 
 creates a symbolic link to the appropriate launcher

 Note: this script is partnered with creatlauncher.py 
 createlauncher.py makes the launchers at installtime, and 
 linklauncher.py creates the links whenever newuser is run.

 Synopsis: python linklauncher.py


@modified: Aug 6 2010
@author: Dale Hamel
@contact: umhameld@cc.umanitoba.ca

"""



import os
import sys
blib = os.environ.get("BIRCHLIB")
sys.path.append(blib)

from birchlib import Birchmod

PROGRAM = "linklauncher.py: "
USAGE = "\n\tUSAGE: linklauncher.py"

PLATFORM = os.environ.get("BIRCH_PLATFORM")


BM = Birchmod(PROGRAM, USAGE)



def get_desktop():
    """
        Returns the location of the current user's desktop directory
        by reading the environment variable "HOME", and assuming that there
        is a "HOME/Desktop" directory
        """
    home_dir = os.environ.get("HOME")
    
    if (os.path.exists(home_dir)):
        desktop_dir = home_dir + "/Desktop"
        
        if (os.path.exists(desktop_dir)):
            print(PROGRAM + "Found desktop at: " + desktop_dir)

        else:
            desktop_dir = None
    
    return desktop_dir

def link_gnome_launcher(desktop_dir):
    """
        Creates a launcher of the form biolegato.desktop for use on
        linux desktops such as GNOME (v2+) and KDE (v3.5+). May also work
        on other desktops such as qt, etc, but not yet tested

        @desktop_dir: the location of the user's desktop directory,
        where the launcher will be placed

        """
        
    birch_dir = os.environ.get("BIRCH")
    file_name = birch_dir + "/admin/launchers/birch.desktop"

    if (birch_dir != None):
        os.chdir(desktop_dir)
        os.system("ln -s "+file_name+" .")
        print("Made symbolic link to launcher on desktop")


def link_apple_launcher(desktop_dir):
    """
        Makes a launcher application for OS X (tested on 10.5.8) of the format
        biolegato.app. The launcher is just a wrapper for an apple script
        that calls the system biolegato, and should use system paths.

        The this method copies a template launcher called "biolegato.app"
        to the desktop that is assumed to be in the current working directory
        in adirectory called "osx_launcher", if this changes then this method
        will need to be updated.

        Once the launcher is copied, all the contents of the BIRCH directory
        specified by the environment variable $BIRCH will be symbolically
        linked into the applications resource directory under:
        
        ~/biolegato.app/Contents/Resources"

        @desktop_dir: the location of the user's desktop directory,
        where the launcher will be placed
        """

    birch_dir = os.environ.get("BIRCH")
 
    if (birch_dir != None):
    	os.chdir(desktop_dir)
   	os.system("ln -s "+birch_dir+"/admin/launchers/biolegato.app .")
   	print(PROGRAM + "Made symbolic link to launcher on desktop")



def link_win_launcher():
    """
	Creates a shortcut to the windows launcher script to run biolegato (birch)
	
    """

    windir=os.environ.get("HOMEDRIVE")+os.environ.get("HOMEPATH")
    os.chdir(windir+"/Desktop")
    print(os.getcwd())
    
    
    #Note: there is a hardcoded link to biolegato here, this should be fixed!
    birch_dir=os.environ.get("BIRCH")
    biolegato=birch_dir+"/java/bioLegato.0.7.2/biolegato.bat"
    birch_icon=birch_dir+"/public_html/smallbirch.ico"
    
    cygwin_bat="/cygwin.bat"
    
    os.system("mkshortcut -n bioLegato -i "+birch_icon+" "+biolegato)
    os.system("mkshortcut -n birchTerm "+cygwin_bat)


def main():
    desktop_dir = get_desktop()
    
    if (desktop_dir != None):
                
        #This assumes either OSX or using gnome/kde, if this changes
        #this switch will need to be updated
        if (not PLATFORM == "osx-x86_64" and  PLATFORM.find("win")<0):
            link_gnome_launcher(desktop_dir)
            

        elif(PLATFORM=="osx-x86_64"):# working in osx

            link_apple_launcher(desktop_dir)
            
    elif(PLATFORM=="winxp-32"):
       	link_win_launcher()
        
    else:
        exit()

    print(PROGRAM + "Completed execution normally.")

if (BM.documentor() or "-test" in sys.argv):
    pass
else:
    main()
