#!/bin/csh

#Version  6/23/98
# Run reticulate as a command
#Synopsis: reticulate.csh infile title method outputtype fontsize outfile 

#Convert arguments to variables
set INFILE        = $1
set TFILE         = $2
set METHOD        = $3
set OUTPUTTYPE    = $4
set FONTSIZE      = $5
set OUTFILE       = $6

set IFN = $INFILE:r

# Make a temporary directory to run the program in 
set TEMPDIR = reticulate.$$
mkdir $TEMPDIR
cp $INFILE $TEMPDIR/infile.temp
cp $TFILE $TEMPDIR/$TFILE
cd $TEMPDIR

# Determine whether sequence is protein or DNA
# Only check for amino acid characters that are not also
# used as DNA ambiguity codes.
grep -v '>' infile.temp > raw.temp
egrep -e '[FPELZIQ*X]'  raw.temp > aa.temp
if ( ! -z aa.temp) then 
   set SEQTYPE = protein
else 
   grep N raw.temp > dna.temp
   if ( -z dna.temp) then
       set SEQTYPE = dna  # DNA, no N's
   else
       set SEQTYPE = dnan #DNA, contains N's
   endif
endif

#----------------- generate keyboard input to send to program -----
echo infile.temp > inputfile # name of sequence file
echo n >> inputfile  # init. gaps not marked in brackets
if ($SEQTYPE == protein) then
   grep N raw.temp > n.temp
   if ( ! -z n.temp) echo n >> inputfile  # X's are not unknowns
   grep X raw.temp > x.temp
   if ( ! -z x.temp)echo n >> inputfile  # N's are not unknowns
else if ($SEQTYPE == dnan) echo n >> inputfile  # N's are not unknowns
endif

head -1 $TFILE >> inputfile  # title line

# Choose site polymorphism method
switch ($METHOD)
  case "1":
    echo "1" >> inputfile # Ignore these sites, use binary sites only
    breaksw
  case "2":
    echo "2" >> inputfile # As transversion sites (DNA/RNA only)
    breaksw
  case "3":
    echo "3" >> inputfile # As sites with more than two characters
    breaksw
  default:
    echo "1" >> inputfile # Ignore these sites, use binary sites only
    breaksw
endsw

echo y >> inputfile      # save informative sites to a file
echo $IFN >> inputfile
echo p >> inputfile      # print the output

if ($OUTPUTTYPE == "eps") then # Encapsulated Postscript
    set OFN = $IFN.eps
    echo e >> inputfile 
else                    # Postscript
    set OFN = $IFN.ps
    echo p >> inputfile
endif

#echo $IFN >> inputfile # name for window

echo $FONTSIZE >> inputfile
echo $IFN >> inputfile    # base name for file
echo " "     >>  inputfile   # name for printout (blank)
echo q  >> inputfile     # quit 


#------ reticulate -----------------------
nice reticulate < inputfile

#----------- Return results to calling directory----------------
mv $OFN  ../$OUTFILE
mv $IFN.sit  ../$IFN.sit

cd ..
/usr/bin/rm -r $TEMPDIR








