"""
June 6th 2010, Dale Hamel, University of Manitoba
 Description: Determines whether the system is OS X or linux, and REMOVES
 the appropriate launcher on the user's desktop.

 **This script is the cleanup script for makelauncher.py, should be called by nobirch
 
 Synopsis: python rmlauncher.py


@modified: June 6 2010
@author: Dale Hamel
@contact: umhameld@cc.umanitoba.ca

"""



import os
import sys

blib = os.environ.get("BIRCHLIB")
sys.path.append(blib)

from birchlib import Birchmod


PROGRAM = "rmlauncher.py: "
USAGE = "\n\tUSAGE: makelauncher.py"
PLATFORM = os.environ.get("BIRCH_PLATFORM")

BM = Birchmod(PROGRAM,USAGE)

def get_desktop():
    """
        Returns the location of the current user's desktop directory
        by reading the environment variable "HOME", and assuming that there
        is a "HOME/Desktop" directory
        """
    home_dir = os.environ.get("HOME")
    
    if (os.path.exists(home_dir)):
        desktop_dir = home_dir + "/Desktop"
        
        if (os.path.exists(desktop_dir)):
            print(PROGRAM + "Found desktop at: " + desktop_dir)

        else:
            desktop_dir = None
    
    return desktop_dir


def rm_gnome_launcher(desktop_dir):
    
    launcher_path = desktop_dir + "/birch.desktop"
    
    if(os.path.exists(launcher_path)):
        remove_launcher(launcher_path)
        
    else:
        print(PROGRAM + "Path :" + launcher_path + " does not exist. Nothing to do.")
        exit()
    
def rm_apple_launcher(desktop_dir):
    
    launcher_path = desktop_dir + "/biolegato.app"
    
    if(os.path.exists(launcher_path)):
        remove_launcher(launcher_path)
    else:
        print(PROGRAM + "Path :" + launcher_path + " does not exist. Nothing to do.")
        exit()

def rm_windows_launcher():
    home_path=os.environ.get("HOMEDRIVE")+os.environ.get("HOMEPATH")
    os.chdir(home_path+"/Desktop")


    os.system("rm bioLegato.lnk")
    os.system("rm birchTerm.lnk")
    
def remove_launcher(launcher_path):
    os.system("rm -r -f " + launcher_path)
    print(PROGRAM + "Removed launcher located at: " + launcher_path)

def main():
    desktop_dir = get_desktop()
    
    if (desktop_dir != None):
                
        #This assumes either OSX or using gnome/kde, if this changes
        #this switch will need to be updated
        if (not PLATFORM == "osx-x86_64" and PLATFORM.find("win")<0):
            rm_gnome_launcher(desktop_dir)
            

        elif(PLATFORM=="osx-x86_64"):# working in osx

            rm_apple_launcher(desktop_dir)
            
        elif(PLATFORM=="winxp-32"):
            rm_windows_launcher()
            
    else:
        exit()

    print(PROGRAM + "Completed execution normally.")
    
if (BM.documentor() or "-test" in sys.argv):
    pass
else:
    main()