#!/bin/csh

####### UNDER CONSTRUCTION

#Version  2/27/2000
# Run drawtree as a command
#Synopsis: rundrawtree.csh infile outformat lableorient lableangle rotation angleofarc 
#                       iterate charheight enthusconst outfile

#Convert arguments to variables
set INFILE      = $1
set OUTFORMAT   = $2
set LABLEORIENT = $3
set LABLEANGLE  = $4
set ROTATION    = $5
set ANGLEOFARC  = $6
set ITERATE     = $7
set CHARHEIGHT  = $8
set ENTHUSCONST = $9
set OUTFILE     = $10

#----------------- generate keyboard input to send to program -----

echo  $OUTFORMAT >> PARAMFILE

# some output formats require additional specifications
switch ($OUTFORMAT)
  case "r":     # Rayshade 
    echo n >> PARAMFILE
    echo y   >> PARAMFILE       #accept defaults
    breaksw
  case "j":     # Hewlett Packard Laserjet
    echo n >> PARAMFILE
    echo 3 >> PARAMFILE         #Resolution 300dpi
    breaksw
  case "p":     # PC Paintbrush PCX format
    echo n >> PARAMFILE
    echo 3  >> PARAMFILE        #Resolution VGA 1024 x 768
    breaksw
  case "x":     #X11 bitmap
    echo n >> PARAMFILE
    echo 1024 >> PARAMFILE      #X resolution
    echo 512 >> PARAMFILE       #Y resolution
    breaksw
  default       # all others, no extra specs. needed
    echo  n >> PARAMFILE          
    breaksw
endsw


# Tree parameters

#if ($USELEN == no) echo 1 >> PARAMFILE

echo 2 >> PARAMFILE
echo $LABLEORIENT >> PARAMFILE
if ($LABLEORIENT == f)  echo $LABLEANGLE >> PARAMFILE

echo 3 >> PARAMFILE
echo $ROTATION >> PARAMFILE

echo 4 >> PARAMFILE
echo $ANGLEOFARC >> PARAMFILE

if ($ITERATE == yes) then
  echo 9  >> PARAMFILE    #Enthusiasm constant is only used 
  echo $ENTHUSCONST >> PARAMFILE       #when tree is iterated
else
    echo 5  >> PARAMFILE               #do not iterate to improve tree
endif

echo 8 >> PARAMFILE
echo $CHARHEIGHT >> PARAMFILE

echo y  >> PARAMFILE   #accept current settings and write plotfile






