#!/usr/local/bin/python

# tacg.py - Run tacg
# Version 2/26/03

# Synopsis:
#   tacg.py args infile outfile pdffile

import sys
import os
import string

# infile and outfile are the last two command line arguments.
INFILE = sys.argv[-3]
OUTFILE = sys.argv[-2]
PDFFILE = sys.argv[-1]

# Create a temporary working directory. 
# This is needed mainly because .ps and .pdf file names are hard
# wired into tacg.
PID = os.getpid()
TEMPDIRNAME = 'tacg.' + str(PID)
os.mkdir(TEMPDIRNAME,0700)
os.chdir(TEMPDIRNAME)

INFILE = os.pardir + os.sep + INFILE
OUTFILE = os.pardir + os.sep + OUTFILE
PDFFILE = os.pardir + os.sep + PDFFILE

# concatenate arguments into a single string
ARGS = ''
for j in range(1,len(sys.argv)-3) :
    ARGS = ARGS + ' ' + sys.argv[j]

COMMANDSTR = 'tacg ' + ARGS + ' < ' + INFILE + ' > ' + OUTFILE

os.system(COMMANDSTR)

if os.path.exists('tacg_Map.pdf') :
      os.rename('tacg_Map.pdf',PDFFILE)
      
if os.path.exists('tacg_Map.ps') :
      os.remove('tacg_Map.ps')

os.chdir(os.pardir)
os.rmdir(TEMPDIRNAME)


