package embl.ebi.trace;

import java.io.*;
import java.util.zip.*;

public abstract class TraceUtils {

	public static byte[] gzipStream2bytes(InputStream inStream) throws IOException {
		// Read and gunzip then into array

		byte[] 			contents;
		byte[] 			buffer;
		int			bytesRead;

		GZIPInputStream 	gzipStreamIn;
		ByteArrayOutputStream	byteStreamOut;

		final int		BUFFER_SIZE = 8192;
	
		buffer = new byte[BUFFER_SIZE];
		byteStreamOut = new ByteArrayOutputStream();
		gzipStreamIn = new GZIPInputStream(inStream);

		while((bytesRead = gzipStreamIn.read(buffer, 0, BUFFER_SIZE)) >= 0){
			byteStreamOut.write(buffer, 0, bytesRead);
			}
		contents = byteStreamOut.toByteArray();	

		byteStreamOut.close();
		gzipStreamIn.close();

		return(contents);
		}
}

