<?xml version='1.0' encoding='ISO-8859-1'?>

<!-- =============================================================== -->
<!--                                                                 -->
<!-- This XSLT stylesheet is for creating plain text from MOBY XML   -->
<!-- for the purpose of sending MOBY data to non-XML applications,   -->
<!-- in this case EMBOSS (or other compatible ACD-based) programs.   -->
<!--                                                                 -->
<!-- This file should be used in conjunction with the TextClient     -->
<!-- class from Seahawk, which must do the type checking and casting -->
<!-- so that the XPath statements used here will work for their MOBY -->
<!-- Object Ontology targets, and their child terms.  The TextClient -->
<!-- will also deal with processing Collections properly.            -->
<!--                                                                 -->
<!-- MOBY data version taken into account on 2007-02-13:             -->
<!--                                                                 -->
<!--     Author: Paul Gordon (gordonp@ucalgary.ca)                   -->
<!--                                                                 -->
<!-- Note that most of the XPath statements in this stylesheet allow -->
<!-- elements and attributes to either have the moby namespace or    -->
<!-- none-at-all.  We are being lenient, but you really should       -->
<!-- assign data to the moby namespace when you're creating          -->
<!-- the XML representation.  Please!                                -->
<!--                                                                 -->
<!-- This stylesheet falls under the same distribution license as    -->
<!-- the jMOBY code base, i.e. the GNU Public License, or the Perl   -->
<!-- Artistic License.                                               -->
<!--                                                                 -->
<!-- =============================================================== -->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0"
		xmlns:dc="http://purl.org/dc/elements/1.1/"
                xmlns:moby="http://www.biomoby.org/moby">

<!-- Normally, the calling transformer would pass in type of EMBOSS data it is expecting to
     be generated.  The convention used here is that mode of the templates indicates the 
     output data type. If the transformer hasn't set this variable, the default here will
     be used. -->
<xsl:param name="selectedACDTypeTarget" select="'default'"/>

<xsl:output method="text"
            media-type="text/plain"
            encoding="ISO-8859-1"/>

  <xsl:preserve-space elements="*" />

  <!-- Root template. Selects the template mode based on the value of $selectedACDTypeTarget -->
  <xsl:template match="/">
     
    <!-- Unfortunately, we cannot do the following
      <xsl:apply-templates select="*" mode="${selectedACDTypeTarget}" />
      because XSLT does not handle variables in the mode attribute.  Therefore for each target
      text data type included in this stylesheet, you must include an if condition here.  See
      http://www.dpawson.co.uk/xsl/sect2/nono.html#d1905e383
	 -->
    <xsl:choose>
      <xsl:when test="$selectedACDTypeTarget = 'FASTA'">
	<xsl:apply-templates select="*" mode="FASTA"/>
      </xsl:when>
      <xsl:when test="$selectedACDTypeTarget = 'sequence'">
	<xsl:apply-templates select="*" mode="sequence"/>
      </xsl:when>
      <xsl:when test="$selectedACDTypeTarget = 'nucleotide-sequence'">
	<xsl:apply-templates select="*" mode="nucleotide-sequence"/>
      </xsl:when>
      <xsl:otherwise>
	<xsl:apply-templates select="*"/>
      </xsl:otherwise>
    </xsl:choose>

  </xsl:template>

  <!-- ****************************************************** -->
  <!-- * Specific MOBY -> text rules start below!           * -->
  <!-- ****************************************************** -->

  <!-- Turn any sequence into a plain-old string -->
  <xsl:template match="moby:NucleotideSequence | NucleotideSequence" name="NucleotideSequence.1" mode="nucleotide-sequence">
    <xsl:value-of select="*[@articleName='SequenceString'] | *[@moby:articleName='SequenceString']"/>
  </xsl:template>

  <xsl:template match="moby:Collection/moby:Simple[./moby:GenericSequence] | Collection/Simple[./GenericSequence]" 
                 name="Collection-GenericSequence.1" mode="seqall">
    <xsl:apply-templates select="moby:GenericSequence | GenericSequence" mode="seqall"/>
  </xsl:template>

  <xsl:template match="moby:GenericSequence | GenericSequence" name="GenericSequence.2" mode="sequence">
    <xsl:apply-templates select="." mode="seqall"/>
  </xsl:template>

  <!-- Turn any sequence into a FastA -->
  <!-- The name of the template is "MobyDataType#uniqueid", so we can parse this
       easily, rather than try to figure out what the arbitrarily complex match attribute 
       XPath is trying to capture. -->
  <xsl:template match="moby:GenericSequence | GenericSequence" name="GenericSequence.1" mode="FASTA">
    <dc:source>urn:lsid:bioxml.info:mobyLoweringSchemaMapping:GenericSequence2FASTA</dc:source>

    <!-- Header line ">namespace|id description" -->
    <xsl:text>&gt;</xsl:text>
       <xsl:value-of select="@namespace | @moby:namespace"/>
         <xsl:if test="string-length(@namespace | @moby:namespace) != 0"><xsl:text>|</xsl:text></xsl:if>
       <xsl:value-of select="@id | @moby:id"/>

       <xsl:if test="*[@articleName='Description']">
	 <xsl:text> </xsl:text><xsl:value-of select="*[@articleName='Description']"/>
       </xsl:if>
    <xsl:text>&#10;</xsl:text> <!-- 10 = ASCII newline -->

    <!-- Sequence -->
    <xsl:value-of select="*[@articleName='SequenceString'] | *[@moby:articleName='SequenceString']"/>
    <xsl:text>&#10;</xsl:text>

  </xsl:template>


  <!-- ****************************************************** -->
  <!-- * Below here are binary equivalencies of formats,    * -->
  <!-- * which don't actually do any transformation, but    * -->
  <!-- * which are kept for TextClient to note and pass the * -->
  <!-- * base64 decoded Moby data as-is.                    * -->
  <!-- ****************************************************** -->

  <xsl:template match="/binarydata" name="ABISequenceChromatogram.1" mode="abi-trace"/>

</xsl:stylesheet>
