package ca.ucalgary.seahawk.util;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTabbedPane;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.Rectangle;
import java.awt.Graphics;
import java.awt.Component;
import java.net.URL;

public class CloseTabIcon extends CombinedIcon{
    public static final String CLOSE_TAB_ICON_RESOURCE = "ca/ucalgary/seahawk/resources/images/tabclose.gif";

    private static Icon closeIcon;

    private JTabbedPane tabbedPane = null;
    private Rectangle closeIconArea;

    public CloseTabIcon() throws Exception{
	this(new NullIcon());
    }

    public CloseTabIcon(Icon otherIcon) throws Exception{
	super(getIcon(), otherIcon);
    }

    public CloseTabIcon(Icon otherIcon, int spacerWidth) throws Exception{
	super(getIcon(), otherIcon, spacerWidth);
    }

    public CloseTabIcon(Icon otherIcon, int spacerWidth, int orient) throws Exception{
	super(getIcon(), otherIcon, spacerWidth, orient);
    }

    public Rectangle getCloseIconArea(){
	return closeIconArea;
    }

    public static Icon getIcon() throws Exception{
	if(closeIcon == null){
	    URL u = Thread.currentThread().getContextClassLoader().getResource(CLOSE_TAB_ICON_RESOURCE);
	    if(u == null){
		throw new Exception("Could not find icon resource " + CLOSE_TAB_ICON_RESOURCE);
	    }
	    else{
		closeIcon = new ImageIcon(u);
	    }
	}
	return closeIcon;
    }

    public void paintIcon(Component c, Graphics g, int x, int y){
	super.paintIcon(c, g, x, y);

	if(c != tabbedPane){
	    if(!(c instanceof JTabbedPane)){
		System.err.println("CloseTabIcon being drawn on a component that is not a JTabbedPane ("+
				   c.getClass()+"), no close functionality is provided");
		return;
	    }
	    tabbedPane = (JTabbedPane) c;
	    tabbedPane.addMouseListener(new Closer(this, tabbedPane));
	}
	
	// The close Icon is the first of the two.  Note its area so we can check for mouse clicks later
	closeIconArea = new Rectangle(x, y, getFirstIcon().getIconWidth(), getFirstIcon().getIconHeight());
    }

    class Closer extends MouseAdapter{
	private CloseTabIcon icon;
	private JTabbedPane tabbedPane;
	private boolean active;

	public Closer(CloseTabIcon cti, JTabbedPane tp){
	    icon = cti;
	    tabbedPane = tp;
	    active = false;
	}

	public void mousePressed(MouseEvent e){
	    if(!e.isConsumed() && getCloseIconArea() != null && 
	       getCloseIconArea().contains(e.getX(), e.getY()) &&
	       tabbedPane.getIconAt(tabbedPane.getSelectedIndex()) == icon){
		active = true;
	    }
	    else{
		active = false;
	    }
	}

	public void mouseReleased(MouseEvent e){
	    // Did the user click in the close icon area, when the icon was being displayed?
	    if(active && !e.isConsumed() && getCloseIconArea() != null && 
	       getCloseIconArea().contains(e.getX(), e.getY())){
		int tabIndex = tabbedPane.getSelectedIndex();
		if(tabIndex < 0){
		    return;
		}
		if(tabbedPane.getIconAt(tabIndex) != icon){
		    // Don't respond unless the close tab icon is actually showing
		    return;
		}
		tabbedPane.remove(tabIndex);
		e.consume(); // so other tabs aren't closed by mistake
		tabbedPane.removeMouseListener(this);
	    }
	}
    }
}
