package ca.ucalgary.seahawk.util;

import javax.swing.Icon;
import java.awt.Graphics;
import java.awt.Component;

public class CombinedIcon implements Icon {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
        
    private int orientation;
    private int spacer; // blank between the icons
    private Icon icon1;
    private Icon icon2;

    public CombinedIcon(Icon firstIcon, Icon secondIcon){
	this(firstIcon, secondIcon, 0);
    }
    public CombinedIcon(Icon firstIcon, Icon secondIcon, int spacer){
	this(firstIcon, secondIcon, spacer, HORIZONTAL);
    }
        
    public CombinedIcon(Icon firstIcon, Icon secondIcon, int spacerPixels, int orient) 
	throws IllegalArgumentException{
	if(orientation != HORIZONTAL && orientation != VERTICAL){
	    throw new IllegalArgumentException("Invalid orientation parameter, " +
					       "must be HORIZONTAL or VERTICAL");
	}
	if(firstIcon == null){
	    throw new IllegalArgumentException("The first Icon passed in was null");
	}
	if(secondIcon == null){
	    throw new IllegalArgumentException("The second Icon passed in was null");
	}

	icon1 = firstIcon;
	icon2 = secondIcon;
	orientation = orient;
	spacer = spacerPixels;
    }
        
    public Icon getFirstIcon(){
	return icon1;
    }

    public Icon getSecondIcon(){
	return icon2;
    }

    public int getIconHeight(){
	if (orientation == VERTICAL){
	    return icon1.getIconHeight() + icon2.getIconHeight() + spacer;
	}
	else{
	    return Math.max(icon1.getIconHeight(), icon2.getIconHeight());
	}
    }
        
    public int getIconWidth(){
	if (orientation == VERTICAL){
	    return Math.max(icon1.getIconWidth(), icon2.getIconWidth());
	}
	else{
	    return icon1.getIconWidth() + icon2.getIconWidth() + spacer;
	}
    }
        
    public void paintIcon(Component c, Graphics g, int x, int y){
	if (orientation == VERTICAL){
	    int heightOfFirst = icon1.getIconHeight();
	    int maxWidth = getIconWidth();
	    icon1.paintIcon(c, g, x + (maxWidth - icon1.getIconWidth())/2, y);
	    icon2.paintIcon(c, g, x + (maxWidth - icon2.getIconWidth())/2, y + heightOfFirst + spacer);
	}
	else{
	    int widthOfFirst = icon1.getIconWidth();
	    int maxHeight = getIconHeight();
	    icon1.paintIcon(c, g, x, y + (maxHeight - icon1.getIconHeight())/2);
	    icon2.paintIcon(c, g, x + widthOfFirst + spacer, y + (maxHeight - icon2.getIconHeight())/2);
	}
    }
        
}
