package ca.ucalgary.seahawk.util;

import java.awt.Component;
import javax.swing.*;

/**
 * This class was created to overcome the basic issue that JPopupMenus do not like to be resized
 * once they have been set visible.  To do this, you must make it invisible, add/delete items, and 
 * then make it visible again.  If you have multiple threads doing this, the popup gets horribly
 * confused and will often leave a blank area on the screen until the application is terminated.  This
 * class synchrionizes setVisible/add/remove calls to the popup so that this confusion, and screen 
 * area blanking is averted.
 *
 * @author Paul Gordon gordonp@ucalgary.ca
 */

public class DynamicJPopupMenu extends JPopupMenu{
    private Object semaphore; 

    public DynamicJPopupMenu(){
	super();
	semaphore = new Object();
    }

    public synchronized void setVisible(boolean b){
	synchronized(semaphore){
	    if(b == isVisible()){
		return;
	    }
	    super.setVisible(b);
	}
    }

    public synchronized JMenuItem add(JMenuItem item){
	synchronized(semaphore){
	    JMenuItem returnItem = super.add(item);
	    revalidate();
	    repaint();
	    return returnItem;
	}
    }

    public synchronized void remove(Component c){
	synchronized(semaphore){
	    super.remove(c);
	}
    }

}
