package ca.ucalgary.seahawk.util;

import org.biomoby.shared.*;
import org.biomoby.shared.data.*;

/**
 * A class that pretends it's a real moby data collection instance, but is actually a deferred list of data collection instances
 * that should be submitted en-masse to services.  Use to implement 'for each' functionality in Seahawk.
 */
public class MobyDataObjectSetDeferred extends MobyDataObjectSet implements MobyContentCreator{
    MobyPrimaryDataSet templateSet;
    MobyPayloadRequestListener dataCreator;

    public MobyDataObjectSetDeferred(MobyPrimaryDataSet template, MobyPayloadRequestListener listener){
	super(template.getName());
	setDataType(template.getDataType());	
	setNamespaces(template.getNamespaces());
	dataCreator = listener;
    }

    public MobyContentInstance getAllContents(String jobParamName){
	return dataCreator.createPayload(jobParamName);
    }
}