package ca.ucalgary.seahawk.util;

/**
 * To be implemented by classes that can provide a Moby payload object 
 * (e.g. to submit to a service) upon request, with the auumption that the listener knows
 * what to send in the context of the class to which it attached itself as a listener.
 *
 * This is used by MobyServicesGUI to request a payload when the menu item was created based on a data
 * type rather than an actual data instance.
 */	
public interface MobyPayloadRequestListener{
    /**
     * Assumes the listener knows what payload to create based on some internal context stored by the listener. 
     * (i.e. you need to create a new listener specific to each deferred payload. 
     *
     * @param paramNameforJobs the name of the moby job  parameter to which each value should be assigned
     */
    public org.biomoby.shared.data.MobyContentInstance createPayload(String paramNameforJobs); 
}
