package ca.ucalgary.services.util.test;

import ca.ucalgary.services.util.ACDFile;
import junit.framework.*;

import java.net.URL;
import java.util.*;

public class ACDFileTestCase extends TestCase{
    private final static String ACDFILE_RESOURCE = "ca/ucalgary/services/util/test/transeq.acd";
    private final static String ACDFILE_SUBSECTION_RESOURCE = "ca/ucalgary/services/util/test/dan.acd";
    private final static String ACDFILE_VARIABLE_RESOURCE = "ca/ucalgary/services/util/test/emma.acd";

    public ACDFileTestCase(String name){
	super(name);
    }

    public void testParsingBasic(){
	URL u = getClass().getClassLoader().getResource(ACDFILE_RESOURCE);
	assertNotNull("Could not find the test ACD file resource ("+ACDFILE_RESOURCE+")", u);

	ACDFile file = null;
	try{
	    file = new ACDFile(u);
	} catch(Exception e){
	    e.printStackTrace();
	    fail("Could not load and parse the test input resource ("+u+"): " + e);
	}
	
	List<Map<String,String>> section = file.getApplicationSection();
	assertNotNull("The application section for the test data file was unexpectedly null", section);
	assertTrue("The number of blocks (" + section.size() +") in the application section of " +
		   u + " was not as expected (expected 1)", section.size() == 1);

	section = file.getInputSection();
	assertNotNull("The input section for the test data file was unexpectedly null", section);
	assertTrue("The number of blocks (" + section.size() +") in the input section of " +
		   u + " was not as expected (expected 1)", section.size() == 1);

	section = file.getRequiredParamsSection();
	assertNotNull("The required parameters section for the test data file was unexpectedly null", section);
	assertTrue("The number of blocks (" + section.size() +") in the required parameter section of " +
		   u + " was not as expected (expected 0)", section.size() == 0);

	section = file.getAdditionalParamsSection();
	assertNotNull("The additional parameters section for the test data file was unexpectedly null", section);
	assertTrue("The number of blocks (" + section.size() +") in the additional parameter section of " +
		   u + " was not as expected (expected 5)", section.size() == 5);

	section = file.getAdvancedParamsSection();
	assertNotNull("The advanced parameters section for the test data file was unexpectedly null", section);
	assertTrue("The number of blocks (" + section.size() +") in the advanced parameter section of " +
		   u + " was not as expected (expected 1)", section.size() == 1);

	section = file.getOutputSection();
	assertNotNull("The output section for the test data file was unexpectedly null", section);
	assertTrue("The number of blocks (" + section.size() +") in the output section of " +
		   u + " was not as expected (expected 1)", section.size() == 1);
    }

    public void testParsingSubsections(){
	URL u = getClass().getClassLoader().getResource(ACDFILE_SUBSECTION_RESOURCE);
	assertNotNull("Could not find the test ACD file resource ("+ACDFILE_SUBSECTION_RESOURCE+")", u);

	ACDFile file = null;
	try{
	    file = new ACDFile(u);
	} catch(Exception e){
	    e.printStackTrace();
	    fail("Could not load and parse the test input resource ("+u+"): " + e);
	}
	
	List<Map<String,String>> section = file.getApplicationSection();
	assertNotNull("The application section for the test data file was unexpectedly null", section);
	assertTrue("The number of blocks (" + section.size() +") in the application section of " +
		   u + " was not as expected (expected 1)", section.size() == 1);

	section = file.getInputSection();
	assertNotNull("The input section for the test data file was unexpectedly null", section);
	assertTrue("The number of blocks (" + section.size() +") in the input section of " +
		   u + " was not as expected (expected 1)", section.size() == 1);

	section = file.getRequiredParamsSection();
	assertNotNull("The required parameters section for the test data file was unexpectedly null", section);
	assertTrue("The number of blocks (" + section.size() +") in the required parameter section of " +
		   u + " was not as expected (expected 4)", section.size() == 4);

	section = file.getAdditionalParamsSection();
	assertNotNull("The additional parameters section for the test data file was unexpectedly null", section);
	assertTrue("The number of blocks (" + section.size() +") in the additional parameter section of " +
		   u + " was not as expected (expected 6)", section.size() == 6);

	section = file.getAdvancedParamsSection();
	assertNotNull("The advanced parameters section for the test data file was unexpectedly null", section);
	assertTrue("The number of blocks (" + section.size() +") in the advanced parameter section of " +
		   u + " was not as expected (expected 1)", section.size() == 1);

	section = file.getOutputSection();
	assertNotNull("The output section for the test data file was unexpectedly null", section);
	assertTrue("The number of blocks (" + section.size() +") in the output section of " +
		   u + " was not as expected (expected 4)", section.size() == 4);
    }

    public void testParsingVariable(){
	URL u = getClass().getClassLoader().getResource(ACDFILE_VARIABLE_RESOURCE);
	assertNotNull("Could not find the test ACD file resource ("+ACDFILE_VARIABLE_RESOURCE+")", u);

	ACDFile file = null;
	try{
	    file = new ACDFile(u);
	} catch(Exception e){
	    e.printStackTrace();
	    fail("Could not load and parse the test input resource ("+u+"): " + e);
	}
	
	List<Map<String,String>> section = file.getApplicationSection();
	assertNotNull("The application section for the test data file was unexpectedly null", section);
	assertTrue("The number of blocks (" + section.size() +") in the application section of " +
		   u + " was not as expected (expected 1)", section.size() == 1);

	section = file.getInputSection();
	assertNotNull("The input section for the test data file was unexpectedly null", section);
	assertTrue("The number of blocks (" + section.size() +") in the input section of " +
		   u + " was not as expected (expected 10)", section.size() == 10);

	section = file.getRequiredParamsSection();
	assertNotNull("The required parameters section for the test data file was unexpectedly null", section);
	assertTrue("The number of blocks (" + section.size() +") in the required parameter section of " +
		   u + " was not as expected (expected 0)", section.size() == 0);

	section = file.getAdditionalParamsSection();
	assertNotNull("The additional parameters section for the test data file was unexpectedly null", section);
	assertTrue("The number of blocks (" + section.size() +") in the additional parameter section of " +
		   u + " was not as expected (expected 16)", section.size() == 16);

	section = file.getAdvancedParamsSection();
	assertNotNull("The advanced parameters section for the test data file was unexpectedly null", section);
	assertTrue("The number of blocks (" + section.size() +") in the advanced parameter section of " +
		   u + " was not as expected (expected 0)", section.size() == 0);

	section = file.getOutputSection();
	assertNotNull("The output section for the test data file was unexpectedly null", section);
	assertTrue("The number of blocks (" + section.size() +") in the output section of " +
		   u + " was not as expected (expected 2)", section.size() == 2);
    }

    /**
     * @return a test suite for all the test methods of this test case.
     */
    public static Test suite() {

	TestSuite suite = new TestSuite();
 	suite.addTest(new ACDFileTestCase("testParsingBasic"));
 	suite.addTest(new ACDFileTestCase("testParsingSubsections"));
 	suite.addTest(new ACDFileTestCase("testParsingVariable"));
        return suite;
    }

    public static void main(String[] args){
	junit.textui.TestRunner.run(suite());
    }
}
