/*   ncbilcl.h
* ===========================================================================
*
*                            PUBLIC DOMAIN NOTICE
*               National Center for Biotechnology Information
*
*  This software/database is a "United States Government Work" under the
*  terms of the United States Copyright Act.  It was written as part of
*  the author's official duties as a United States Government employee and
*  thus cannot be copyrighted.  This software/database is freely available
*  to the public for use. The National Library of Medicine and the U.S.
*  Government have not placed any restriction on its use or reproduction.
*
*  Although all reasonable efforts have been taken to ensure the accuracy
*  and reliability of the software and data, the NLM and the U.S.
*  Government do not and cannot warrant the performance or results that
*  may be obtained by using this software or data. The NLM and the U.S.
*  Government disclaim all warranties, express or implied, including
*  warranties of performance, merchantability or fitness for any particular
*  purpose.
*
*  Please cite the author in any work or product based on this material.
*
* ===========================================================================
*
* File Name:  ncbilcl.h
*
* Author:  Gish, Kans, Ostell, Schuler, Epstein
*
* Version Creation Date:   8/1/94
*
* $Revision: 6.9 $
*
* File Description:
*		system dependent header
*       version for Darwin 1.2.*
*
* Modifications:
* --------------------------------------------------------------------------
* Date     Name          Description of modification
* -------  ----------    ---------------------------------------------------
*
* $Log: ncbilcl.dwn,v $
* Revision 6.9  2007/04/06 21:10:32  kans
* also check for 64-bit processor conditional symbols
*
* Revision 6.8  2007/04/02 16:06:12  kans
* use __ppc__ and __i386__ to set proper PROC_ platform flags
*
* Revision 6.7  2005/11/16 16:22:32  kans
* support for PowerPC and Intel chips in PROC_ and _ENDIAN flags
*
* Revision 6.6  2003/09/05 21:22:58  beloslyu
* add DARWIN def
*
* Revision 6.5  2003/02/28 14:59:40  kans
* changed PROC_POWERPC to correct PROC_PPC platform symbol
*
* Revision 6.4  2002/11/22 20:05:04  lavr
* Configure HAVE_STRDUP and HAVE_STRCASECMP
*
* Revision 6.3  2002/01/22 16:34:54  kans
* contributor contact information copied from obsolete readme.macosx file
*
* Revision 6.2  2001/04/03 21:01:54  beloslyu
* changed to big endian (according to Nathan Willard <willard@turbogenomics.com>)
*
* Revision 6.1  2001/01/19 20:28:42  kans
* initial checkin - contributed by William Van Etten <vanetten@computefarm.com>
*
*   William Van Etten, PhD
*   Blackstone Technology Group
*   80 Summer Street
*   Boston, MA 02110
*   617-542-4770 x4003
*   vanetten@computefarm.com
*
* Revision 1.1  2001/01/13 15:42:41  vanetten
* port to Darwin 1.2
*
*
*
* ==========================================================================
*/
#ifndef _NCBILCL_
#define _NCBILCL_

/* PLATFORM DEFINITION FOR Darwin 1.2.* */

#define COMP_BSD
#define OS_UNIX
#define DARWIN
#define OS_UNIX_DARWIN

/* Mac may be PowerPC or Intel chip */
#if defined(__ppc__) || defined(__ppc64__)
#define PROC_PPC
#endif
#if defined(__i386__) || defined(__x86_64__)
#define PROC_I80X86
#define PROC_I80_386
#endif

/* for backward compatibility */
#ifndef PROC_I80X86 
#ifndef PROC_PPC 
#define PROC_PPC 
#endif 
#endif 

#define WIN_DUMB

/*----------------------------------------------------------------------*/
/*      Desired or available feature list                               */
/*----------------------------------------------------------------------*/

/*----------------------------------------------------------------------*/
/*      #includes                                                       */
/*----------------------------------------------------------------------*/
#include <sys/types.h>
#include <limits.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <stddef.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <memory.h>
#include <stdlib.h>
#include <math.h>
#include <errno.h>
#include <float.h>
#include <unistd.h>

/* Check if there are POSIX threads available */
#ifdef _POSIX_THREADS
#define POSIX_THREADS_AVAIL
#endif
#define HAVE_STRCASECMP 1
#define HAVE_STRDUP 1

/*----------------------------------------------------------------------*/
/*      Missing ANSI-isms                                               */
/*----------------------------------------------------------------------*/
#ifndef SEEK_SET
#define SEEK_SET	0	/* Set file pointer to offset */
#define SEEK_CUR	1	/* Set file pointer to current plus offset */
#define SEEK_END	2	/* Set file pointer to EOF plus offset */
#endif
#ifndef FILENAME_MAX
#define FILENAME_MAX 1024
#endif
#ifndef LOGNAME_MAX
#define LOGNAME_MAX	MAXLOGNAME
#endif
#ifdef ALIGN
#undef ALIGN
#endif

/*----------------------------------------------------------------------*/
/*      Aliased Logicals, Datatypes                                     */
/*----------------------------------------------------------------------*/
#ifndef sigset
#define sigset signal
#endif
/*----------------------------------------------------------------------*/
/*      Misc Macros                                                     */
/*----------------------------------------------------------------------*/
#define PROTO(x) x	/* Prototypes are acceptable */
#define VPROTO(x) x   /* Prototype for variable argument list */
#define DIRDELIMCHR     '/'
#define DIRDELIMSTR     "/"
#define CWDSTR          "."

#define KBYTE           (1024)
#define MBYTE           (1048576)

/* Mac may be PowerPC or Intel chip */
#ifdef __BIG_ENDIAN__ 
#define IS_BIG_ENDIAN 
#endif 
#ifdef __LITTLE_ENDIAN__ 
#define IS_LITTLE_ENDIAN 
#endif 

/* for backward compatibility */
#ifndef IS_LITTLE_ENDIAN 
#ifndef IS_BIG_ENDIAN 
#define IS_BIG_ENDIAN 
#endif 
#endif 

#define TEMPNAM_AVAIL

/*----------------------------------------------------------------------*/
/*      For importing MS_DOS code                                       */
/*----------------------------------------------------------------------*/
#define near
#define far
#define huge
#define cdecl
#define pascal
#define _pascal
#define _near
#define _far
#define _huge
#define _cdecl

/*----------------------------------------------------------------------*/
/*      Macros for Floating Point                                       */
/*----------------------------------------------------------------------*/
#define EXP2(x) exp((x)*LN2)
#define LOG2(x) (log(x)*(1./LN2))
#define EXP10(x) exp((x)*LN10)
#define LOG10(x) log10(x)

/*----------------------------------------------------------------------*/
/*      Macros Defining Limits                                          */
/*----------------------------------------------------------------------*/
#define MAXALLOC	0x40000000 /* Largest permissible memory request */

#endif

