#!/usr/local/python/bin/python

# Create a .GDEmenus file by concatenating .item
# files.
# Version 06/06/07


import os
import sys
import string
import fileinput


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
class Menulist :
      def __init__(self) :
          self.Menus = []
	  self.CURRENT = -1
	  self.MLEN = 0

      # Return the index of a menu, or -1 if menu does not
      # already exist.
      def MI(self,MNAME) :
          I = 0
	  FOUND = -1
	  self.MLEN = len(self.Menus)
	  while (I < self.MLEN) and (FOUND == -1) :
	       if self.Menus[I].Name == MNAME :
	          FOUND = I
	       I = I + 1
          return FOUND
      	  
      # add NAME to the menu list.
      def addMenu(self,NAME) :
	     NEWMENU = self.Menu(NAME)
	     self.Menus.append(NEWMENU)
	  	        
      # . . . . . . . . . . . . . . . . . . . . . 
      class Menu :
	    def __init__(self,NAME) :
	        self.Name = NAME
        	self.Items = []
		
            # Return the index of an item, or -1 if item does not
            # already exist.
            def II(self,INAME) :
                I = 0
	        FOUND = -1
	        self.ILEN = len(self.Items)
	        while (I < self.ILEN) and (FOUND == -1) :
	             if self.Items[I].itemname == INAME :
	                FOUND = I
	             I = I + 1
                return FOUND

	    def addItem(self,DIR,NAME,PLATFORM) :
	        NEWITEM = self.Item(DIR,NAME,PLATFORM)
		self.Items.append(NEWITEM)
	
            # . . . . . . . . . . . . . . . . . . . . . 
	    class Item :
		  def __init__(self,DIR,N,P) :
		      self.dir = DIR
		      self.itemname = N
		      self.platforms = P


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# Read the menu list file
def READLIST(DIR,FN) :


    # - - - - - - - - - - - - - - - - - - - - - - - - 
    # Split up input line into 3 tab-separated fields.
    # If there are fewer than 3 fields in input, return
    # empty fields to make up the difference.
    def TOKENIZE(LINE) :
	# Parse the line into tokens
	TOKENS = string.split(LINE,"\t")
	PADDING = 3 - len(TOKENS)
	for I in range (0,PADDING) :
            TOKENS.append("")
	# Strip off whitespace
	for I in range (0,3) :
            TOKENS[I] = string.strip(TOKENS[I])      
        return TOKENS
    
    # . . . . . . . . . . . . . . . . . . . . . . .
    FILE = open(FN,'r')
    LINE = FILE.readline()

    while LINE != '':
    
          # Parse the line into tokens
          TOKENS = TOKENIZE(LINE)  
	  
	  # Create a menu or item, depending on values of tokens
	  if TOKENS[0] <> "" :
	     M.CURRENT = M.MI(TOKENS[0])
	     if M.CURRENT == -1 :	     
	        M.addMenu(TOKENS[0])
		M.CURRENT = len(M.Menus)-1
	  elif TOKENS[1] <> "" :
	     # If a menu item already exists, and an item is
	     # read with the same name, overwrite the existing
	     # item with the new item. Otherwise, append it
	     # as a new item.
	     ILOC = M.Menus[M.CURRENT].II(TOKENS[1])
	     if ILOC == -1 :
	        M.Menus[M.CURRENT].addItem(DIR+'/'+M.Menus[M.CURRENT].Name,
	                                TOKENS[1],TOKENS[2])
	     else:
	        M.Menus[M.CURRENT].Items[ILOC].__init__(DIR+
	              '/'+M.Menus[M.CURRENT].Name,TOKENS[1],TOKENS[2])
	  else :
             pass
	  LINE = FILE.readline()
    FILE.close()


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# Print usage message
def PRINTUSAGE() :
    print """
    Usage: makemenus.py [-p platform]
              platform S (solaris-sparc)
                       s (solaris-amd64)
                       L (linux-intel)
                       l (linux-x86_64)
                       M (OSX-Mac)
    """

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# Print summary of menus to screen
def PRINTSUMMARY(M) :
    for I in range (0,len(M.Menus)) :
	print M.Menus[I].Name
	for J in range (0,len(M.Menus[I].Items)) :
            print "\t" + M.Menus[I].Items[J].itemname + " " + \
	          M.Menus[I].Items[J].platforms

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# Write out the merged menus to .GDEmenus

def WRITEMENUS(M,PLATFORM,OFN) :

    # . . . . . . . . . . . . . . . . . . . . . . 
    def COPYLINES(ITEMFILE,OUTFILE) :
    	OUTFILE.write("")
	for LINE in fileinput.input(ITEMFILE) :
             OUTFILE.write(LINE)
	
    # . . . . . . . . . . . . . . . . . . . . . . 

    OUTFILE = open(OFN,'w')

    # Write header comments first
    if PLATFORM == "S" :
       OUTFILE.write('# .GDEmenus' + ' for Solaris-Sparc ' + "\n") 
    elif PLATFORM == "s" :
       OUTFILE.write('# .GDEmenus' + ' for Solaris-AMD64 ' + "\n") 
    elif PLATFORM == "L" :
       OUTFILE.write('# .GDEmenus' + ' for Linux-Intel ' + "\n") 
    elif PLATFORM == "l" :
       OUTFILE.write('# .GDEmenus' + ' for Linux-x86_64 ' + "\n")
    elif PLATFORM == "M" :
       OUTFILE.write('# .GDEmenus' + ' for OSX-Mac ' + "\n") 
    else :
       OUTFILE.write('# .GDEmenus' + "\n")    
    
    OUTFILE.write('# This file was automatically generated by makemenus.py.' + "\n")
    OUTFILE.write('# Changes should be made to individual .item files,' + "\n")
    OUTFILE.write('# and the .GDEmenus file re-created using makemenus.py.' + "\n")    
    COPYLINES('header.item',OUTFILE)
    OUTFILE.write("\n")
    
    # Write each file to OUTFILE
    
    HASHMARKS = '##############################'
    
    for I in range (0,len(M.Menus)) :
    
        # Don't add empty menus to .GDEmenus
        if len(M.Menus[I].Items) > 0 :
           MENUNAME = M.Menus[I].Name
	   
	   # Special case: the DNA/RNA menu is hardwired into GDE.
	   # If the menu is NOT named DNA/RNA, we would lose the 
	   # Complement function, which is hardwired into GDE.
	   # However, it is a very bad idea to allow a directory name
	   # to include '/'. So, we call the directory DNARNA, and
	   # just add the '/' to the menu name when writing the 
	   # .GDEmenus file. 
	   if (MENUNAME == "DNARNA") :
	      MENUNAME = "DNA/RNA"
	   OUTFILE.write("\n")

	   # Write a header for each menu
	   OUTFILE.write(HASHMARKS + ' ' + MENUNAME +
	        	 ' ' + HASHMARKS + "\n")
	   OUTFILE.write('menu:' + MENUNAME + "\n") 
	   OUTFILE.write("\n")

	   # Write out each item
	   for J in range (0,len(M.Menus[I].Items)) :
	       # If platform field is empty, or if platform is
	       # explicitly included for the item, add it to
	       # the output.
	       if (M.Menus[I].Items[J].platforms == "") or \
	          (string.find(M.Menus[I].Items[J].platforms,PLATFORM) > -1) :
		  IFN = M.Menus[I].Items[J].dir + '/' + \
	        	M.Menus[I].Items[J].itemname + '.item'
		  if os.path.exists(IFN) :
        	     COPYLINES(IFN,OUTFILE)
		     OUTFILE.write("\n")
		  else :
		     print 'File ' + IFN + ' not found'
	   
    OUTFILE.close()
    
    # Make sure .GDEmenus file is world readable
    os.chmod(OFN,0644)

#     
#======================== MAIN PROCEDURE ==========================

#---------- Set global variables

OFN = ""
PLATFORM = ""
STARTDIR=os.getcwd()
MENUDIR = STARTDIR + '/' + 'makemenus/menus'
print 'MENUDIR = ' + MENUDIR
HELP = "0"

# Read command line arguments, if any.
NUMARGS = len(sys.argv)
I = 1
while (I < NUMARGS) and (HELP == "0") :
      if sys.argv[I] == "-p" :
         I = I + 1
         if I < NUMARGS :
            PLATFORM = sys.argv[I]
	    I = I + 1
      elif sys.argv[I] == "-h" :
         HELP = "1"
      else :
         I = I + 1
         
   
# Check parameters
OKAY=1
PLATLIST = ['S','s','L','l','M']
if (OFN <> "") :
   if (len(PLATFORM) > 1) :
      OKAY=0
      print '-p option only allows 1 platform to be specified'
   elif (PLATLIST.count(PLATFORM) == 0) :
      OKAY=0
      print PLATFORM + ' not a valid platform'
   else :
      pass 

	 
if (HELP == "0") and (OKAY == 1) :

   M = Menulist()

   # Read the menu list file

   os.chdir(MENUDIR)
   MENUFN = 'menulist'
   READLIST(MENUDIR,MENUFN)

   # Read the local menu list file and merge menu items
   # into menus
   # PARAMFN is the name of the file containing the name of
   # the directory with local menus, if any.
   LDIR = ""
   PARAMFN = STARTDIR + '/' + 'makemenus/ldir.param'
   if os.path.exists(PARAMFN) :
      print('Param file:' + PARAMFN)
      PARAMFILE = open(PARAMFN,'r') 
      LDIR = string.strip(PARAMFILE.readline())
      PARAMFILE.close()    
   if os.path.exists(LDIR) :
      print('Local directory: ' + LDIR)
      os.chdir(LDIR)
      MENUFN = 'menulist'
      if os.path.exists(MENUFN) : 
	 READLIST(LDIR,MENUFN)
         print('Menu file: ' + MENUFN)
   os.chdir(STARTDIR)

   # Write out the merged menus to .GDEmenus
   PRINTSUMMARY(M)

   # .GDEmenus files are written for each supported platform.
   # These are:
   #    S - solaris-sparc
   #    s - solaris-amd64
   #    L - linux-intel
   #    l - linux-x86_64 
   #    M - OSX-Mac 
   #    i - solaris-intel (not currently supported)

   os.chdir(MENUDIR)
   OFN = STARTDIR + '/' + 'GDEHELP-solaris-sparc/.GDEmenus'
   WRITEMENUS(M,'S',OFN)
   OFN = STARTDIR + '/' + 'GDEHELP-solaris-amd64/.GDEmenus'
   WRITEMENUS(M,'s',OFN)
   OFN = STARTDIR + '/'  + 'GDEHELP-linux-intel/.GDEmenus'
   WRITEMENUS(M,'L',OFN)
   OFN = STARTDIR + '/'  + 'GDEHELP-linux-x86_64/.GDEmenus'
   WRITEMENUS(M,'l',OFN)
   OFN = STARTDIR + '/' + 'GDEHELP-OSX-Mac/.GDEmenus'
   WRITEMENUS(M,'M',OFN)
else :
   PRINTUSAGE()
	 
