#!/bin/csh 
# fasta2install.csh  10/31/07


#------------- Set environment variables
#Check to see if $MAILID is set
if ( ! ${?MAILID}) then
  set MAILID = `grep BirchProps.adminEmail ../../local/admin/BIRCH.properties |cut -f2 -d"="`
  if ("$MAILID" == "") then
     set MAILID = `whoami`
  endif
endif

set RM = 'rm -f'

# On some systems, cp is aliased to cp -i to force interactive mode.
# We want to make sure that that alias is removed.
unalias cp

if (${?BIRCH} == 0) then
   set BIRCH = `grep BirchProps.homedir ../../local/admin/BIRCH.properties |cut -f2 -d"="`
endif

if (${?BIRCH_PLATFORM} == 0) then
   set BIRCH_PLATFORM = `grep BirchProps.platform ../../local/admin/BIRCH.properties |cut -f2 -d"="`
   switch ($BIRCH_PLATFORM)
     case "solaris-sparc":
       setenv BIRCH_BIN  bin-solaris-sparc
       setenv RM_CMD /usr/bin/rm
       breaksw  
     case "solaris-amd64":
       setenv BIRCH_BIN  bin-solaris-amd64
       setenv RM_CMD /usr/bin/rm
       breaksw  
     case "sun":   # DEPRECATED
       setenv BIRCH_BIN  bin-solaris-sparc
       setenv RM_CMD /usr/bin/rm
       breaksw
     case "linux-intel":
       setenv BIRCH_BIN  bin-linux-intel
       setenv RM_CMD /bin/rm
       breaksw
     case "linux-x86_64":
       setenv BIRCH_BIN  bin-linux-x86_64
       setenv RM_CMD /bin/rm
       breaksw
     case "AIX":
       setenv BIRCH_BIN  bin-AIX
       breaksw
     case "HP":
       setenv BIRCH_BIN  bin-HP
       breaksw
     default:
       setenv BIRCH_BIN  bin-solaris-sparc
       setenv RM_CMD /usr/bin/rm
       breaksw
   endsw
endif



   
set HOST = ftp.ebi.ac.uk
set DIR = pub/software/unix/fasta 
set USERID = anonymous
set PASSWD = $MAILID
set COMPFILE = fasta2.shar.Z #symbolic link pointing to latest version

if (-e fasta2) then
   $RM_CMD -rf fasta2
   endif
   
mkdir fasta2
cd fasta2

# ------------ Download archive file by FTP
# 
  # generate FTP command file
  # We need to run in the passive mode, which is required by
  # some firewalls.
  # There is a lot of inconsistency from system to system as far
  # as how ftp is run in the passive mode. One or more of these
  # works on each system, but none works on all systems:
  # ftp -p
  # ftp, input 'passive' from ftp.input
  # pftp
  # 
  # set FTP command
  set RESULT = `which pftp | wc -w`
   if ( "$RESULT" == "1" ) then
      set FTPCOMMAND = 'pftp'
   else
      set FTPCOMMAND = 'ftp -p'
   endif
   echo user $USERID $PASSWD > ftp.input
   echo cd $DIR >>  ftp.input
   echo bin >> ftp.input
   echo get $COMPFILE  >>  ftp.input
   echo bye >> ftp.input
  # run FTP
  nice $FTPCOMMAND -i -n $HOST < ftp.input
  
echo FTP completed

#uncompress $COMPFILE
gunzip $COMPFILE
set SHARFILE = $COMPFILE:r
sh $SHARFILE
chmod a+r *


# -------------  Binary files
set BINFILES = ( align align0 garnier grease lalign lfasta prdf prss )

# Default is HZ=100. See Makefile
if ( $BIRCH_PLATFORM == solaris-sparc | $BIRCH_PLATFORM == solaris-amd64 ) then 

   # Not sure what this does, but we need it on solaris-sparc
   mv Makefile Makefile.bak
   sed -e "s/^HZ=100/HZ=60/" <Makefile.bak > Makefile


   #Check to see which compilers are available.
   set COUNT = `which cc | egrep -c -e '^/.*/cc$'`
   if ($COUNT == 1) then
      set CC = 1
   else
      set CC = 0
   endif 
      
   set COUNT = `which gcc | egrep -c -e '^/.*/gcc$'`
   if ($COUNT == 1) then
      set GCC = 1
   else
      set GCC = 0
   endif    


   # Bill Pearson's Makefile.sun defaults to use the Sun cc compiler, which
   # is often not available on many Solaris systems. Even worse, there are
   # some systems in which 'which cc' reports a file, but trying to run
   # cc gives a message saying
   #
   # /usr/ucb/cc:  language optional software package not installed
   #
   # The following code
   # changes the Makefile to use gcc instead of cc. 

   if ($GCC == 1) then
       # Replace the sun cc command with the gcc command
       sed -e 's/^CC=.*/CC= gcc -g -O3/'  < Makefile > Makefile.fixed
       mv Makefile Makefile.original
       mv Makefile.fixed Makefile
   else
      if ($CC == 0) then
	echo "ERROR: no C compiler available. Can't compile fast2 package."
	exit 
      endif        
   endif           
 
      
endif



# We do it this way, rather than just 'make' because as of 
# fasta21u1d0.shar.Z (10/28/02) make would terminate in an error
# if you try to make all targets on Red Hat Linux 7.2. This
# did work in Solaris. Anyway, this approach doesn't waste time
# compiling programs that won't be used in BIRCH
nice make $BINFILES

chmod a+rx $BINFILES

cp -p $BINFILES $BIRCH/$BIRCH_BIN

# -------------- Manual pages
chmod 644 *.1
cp -p *.1 $BIRCH/manl

# -------------- Documentation files
chmod 644 *.doc *.me
cp -p COPYRIGHT *.doc *.me $doc/fasta

# -------------- Scoring Matrices, Sample sequences
chmod 644 *.mat *.aa *.seq
cp -p *.mat *.aa *.seq $dat/fasta2




