#!/bin/csh 
# fasta3install.csh  10/31/07


#------------- Set environment variables
#Check to see if $MAILID is set
if ( ! ${?MAILID}) then
  set MAILID = `grep BirchProps.adminEmail ../../local/admin/BIRCH.properties |cut -f2 -d"="`
  if ("$MAILID" == "") then
     MAILID = `whoami`
  endif
endif
set RM = 'rm -f'


# On some systems, cp is aliased to cp -i to force interactive mode.
# We want to make sure that that alias is removed.
unalias cp

if (${?BIRCH} == 0) then
   set BIRCH = `grep BirchProps.homedir ../../local/admin/BIRCH.properties |cut -f2 -d"="`
endif

if (${?BIRCH_PLATFORM} == 0) then
   set BIRCH_PLATFORM = `grep BirchProps.platform ../../local/admin/BIRCH.properties |cut -f2 -d"="`
   switch ($BIRCH_PLATFORM)
     case "solaris-sparc":
       setenv BIRCH_BIN  bin-solaris-sparc
       setenv RM_CMD /usr/bin/rm
       breaksw 
     case "solaris-amd64":
       setenv BIRCH_BIN  bin-solaris-amd64
       setenv RM_CMD /usr/bin/rm
       breaksw   
     case "sun":   # DEPRECATED
       setenv BIRCH_BIN  bin-solaris-sparc
       setenv RM_CMD /usr/bin/rm
       breaksw
     case "linux-intel":
       setenv BIRCH_BIN  bin-linux-intel
       setenv RM_CMD /bin/rm
       breaksw
     case "linux-x86_64":
       setenv BIRCH_BIN  bin-linux-x86_64
       setenv RM_CMD /bin/rm
       breaksw
     case "AIX":
       setenv BIRCH_BIN  bin-AIX
       breaksw
     case "HP":
       setenv BIRCH_BIN  bin-HP
       breaksw
     default:
       setenv BIRCH_BIN  bin-solaris-sparc
       setenv RM_CMD /usr/bin/rm
       breaksw
   endsw
endif



set HOST = ftp.ebi.ac.uk
set DIR = pub/software/unix/fasta 
set USERID = anonymous
set PASSWD = $MAILID
set COMPFILE = fasta3.shar.Z #symbolic link pointing to latest version

if (-e fasta3) then
   $RM_CMD -rf fasta3
   endif
mkdir fasta3
cd fasta3

# ------------ Download archive file by FTP
# 
  # generate FTP command file
  # We need to run in the passive mode, which is required by
  # some firewalls.
  # There is a lot of inconsistency from system to system as far
  # as how ftp is run in the passive mode. One or more of these
  # works on each system, but none works on all systems:
  # ftp -p
  # ftp, input 'passive' from ftp.input
  # pftp
  # 
  set RESULT = `which pftp | wc -w`
   if ( "$RESULT" == "1" ) then
      set FTPCOMMAND = 'pftp'
   else
      set FTPCOMMAND = 'ftp -p'
   endif
   echo user $USERID $PASSWD > ftp.input
   echo cd $DIR >>  ftp.input
   echo bin >> ftp.input
   echo get $COMPFILE  >>  ftp.input
   echo bye >> ftp.input
  # run FTP
  nice $FTPCOMMAND -n $HOST < ftp.input
  
echo FTP completed

#uncompress $COMPFILE
gunzip $COMPFILE
set SHARFILE = $COMPFILE:r
sh $SHARFILE
chmod a+r *


if ( $BIRCH_PLATFORM == solaris-sparc ) then 
   # Default is HZ=100. See Makefile
   # Not sure what this does, but we need it on solaris-sparc
   mv Makefile Makefile.bak
   sed -e "s/^HZ=100/HZ=60/" <Makefile.bak > Makefile
   
   #Check to see which compilers are available.
   set COUNT = `which cc | egrep -c -e '^/.*/cc$'`
   if ($COUNT == 1) then
      set CC = 1
   else
      set CC = 0
   endif 
      
   set COUNT = `which gcc | egrep -c -e '^/.*/gcc$'`
   if ($COUNT == 1) then
      set GCC = 1
   else
      set GCC = 0
   endif    


   # Bill Pearson's Makefile.sun defaults to use the Sun cc compiler, which
   # is often not available on many Solaris systems. Even worse, there are
   # some systems in which 'which cc' reports a file, but trying to run
   # cc gives a message saying
   #
   # /usr/ucb/cc:  language optional software package not installed
   #
   # The following code
   # changes the Makefile to use gcc instead of cc. 

   if ($GCC == 1) then
       # Replace the sun cc command with the gcc command
       sed -e 's/^CC=.*/CC= gcc -g -O3/'  < Makefile.sun > Makefile.sun.fixed
       mv Makefile.sun Makefile.sun.original
       mv Makefile.sun.fixed Makefile.sun
   else
      if ($CC == 0) then
	echo "ERROR: no C compiler available. Can't compile fast3 package."
	exit 
      endif        
   endif           
 
      
endif


# -------------  Binary files

switch ($BIRCH_PLATFORM)
  case "solaris-sparc":
    nice make -f Makefile.sun
    breaksw
  case "solaris-amd64":
    nice make -f Makefile.sun_x86
    breaksw
  case "sun":  # DEPRECATED
    nice make -f Makefile.sun
    breaksw
  case "linux-intel":
    nice make -f Makefile.linux
    breaksw
  case "linux-x86_64":
    nice make -f Makefile.linux
    breaksw    
  case "AIX":
    nice make -f Makefile.ibm   
    breaksw
  default:
    echo Makefile not available for this platform, or '$BIRCH_PLATFORM' not set
    breaksw
endsw


set TPROGS = ( ssearch34_t fasta34_t  fasts34_t tfasta34_t fastx34_t tfastx34_t\
               fasty34_t tfasty34_t tfasts34_t fastm34_t )

set SPROGS = ( fasta34 ssearch34  prss34 fasts34 tfasta34 fastx34 tfastx34\
                fasty34 tfasty34 tfasts34 fastm34)
set BINFILES = ( $TPROGS $SPROGS )
chmod a+rx $BINFILES

foreach FILE ($BINFILES)
        cp -p $FILE $BIRCH/$BIRCH_BIN/$FILE
end

# -------------- Manual pages
chmod 644 *.1
cp -p *.1 $BIRCH/manl

# -------------- Documentation files
chmod 644 *.doc *.me
cp -p COPYRIGHT FASTA_LIST README* *.doc *.me $doc/fasta

# -------------- Scoring Matrices, Sample sequences
chmod 644 *.mat *.aa *.seq
cp -p *.mat *.aa *.seq $dat/fasta




