#!/bin/csh

# This script is for use in workshops in which
# students create their own mini BIRCH sites. 
# It is NOT needed for a full standalone BIRCH installation.

# Most of the directories will merely be links
# to real BIRCH directories elsewhere on the system.
# The student downloads the birch admininstrative
# and documentation directories, and configures
# them. 

# Next, makelinks.csh makes symbolic links for mini-BIRCH.
# MASTER is the location of the master copy of BIRCH
# By making symbolic links for most of the BIRCH
# directories to those in $MASTER, each student
# can, in effect, create their own BIRCH site.

cd ..
set MASTER = $argv[1]
if ( -e $MASTER ) then

   foreach file (`cat install-birch/minibirch.links`)
      echo $file
      ln -s $MASTER/$file $file
   end
else
   echo $MASTER not found
endif

