#!/bin/csh

# Set BIRCH_PLATFORM environment variable in platform.source
# and platform.profile.source by uncommenting one of the 
# lines in each file.

#Synopsis: setplatform.csh platform
#

if ( "$1" == solaris-sparc || "$1" == solaris-amd64 || "$1" == linux-intel || "$1" == linux-x86_64 ) then
   set platform = $1
   # RM_CMD - command to be used for removing files and directories
   if (-e /usr/bin/rm) then
      set RM_CMD = /usr/bin/rm
   else
      if (-e /bin/rm) then
	 set RM_CMD = /bin/rm
      else
	 set RM_CMD = rm
      endif
   endif

   unset noclobber
   sed "s/#setenv BIRCH_PLATFORM $platform/setenv BIRCH_PLATFORM $platform/" \
     < ../local/admin/platform.source > temp
   cat temp  > ../local/admin/platform.source
   $RM_CMD -f temp

   sed "s/#BIRCH_PLATFORM=$platform/BIRCH_PLATFORM=$platform/" \
     < ../local/admin/platform.profile.source > temp
   cat temp > ../local/admin/platform.profile.source
   $RM_CMD -f temp

else
  echo 'setplatform.csh: invalid platform ('$1')'
  exit 1
endif
 

