ENTRY           A03191  #type fragments
TITLE           antifreeze glycoprotein 3 - bald rockcod (fragments)
ORGANISM        #formal_name Pagothenia borchgrevinki #common_name bald
                rockcod
DATE            05-Oct-1988 #sequence_revision 19-Nov-1988 #text_change
                15-May-1998
ACCESSIONS      A03191
REFERENCE       A92083
   #authors     DeVries, A.L.; Vandenheede, J.; Feeney, R.E.
   #journal     J. Biol. Chem. (1971) 246:305-308
   #title       Primary structure of freezing point-depressing
                glycoproteins.
   #cross-references MUID:71104882; PMID:5542001
   #accession   A03191
      ##molecule_type protein
      ##residues 1-31 ##label DEV
      ##note the three major glycoproteins (3, 4, and 5) have the same
                amino-terminal sequence, Ala-Ala-Thr-Ala-Ala-Thr, and
                carboxyl-terminal Ala. Each protein is composed only of Ala
                and Thr residues in a ratio of 2:1 and arranged in the
                repeating sequence Ala-Ala-Thr
      ##note all threonine residues have carbohydrate (the disaccharide
                galactosyl-N-acetylgalactosamine) that is bound
                glycosidically; the three proteins may differ only in the
                number of repeating units of Ala-Ala-Thr
REFERENCE       A90178
   #authors     Lin, Y.; Duman, J.G.; DeVries, A.L.
   #journal     Biochem. Biophys. Res. Commun. (1972) 46:87-92
   #title       Studies on the structure and activity of low molecular
                weight glycoproteins from an antarctic fish.
   #cross-references MUID:72056127; PMID:5006918
   #contents    annotation
   #note        the small glycopeptides 7 and 8 appear to contain 20 and 14
                residues, respectively, and to have the same amino-terminal
                sequence and carboxyl-terminal residue as the three major
                proteins; however, each has two proline residues (instead of
                one of the alanines in each of two repeating units)
COMMENT         This fish lives in Antarctic waters where it experiences
                water temperatures near -1.9 degrees C. Its blood has a
                freezing point of about -2.0 degrees, and 30% of the
                freezing-point depression is due mainly to the three major
                high molecular weight glycoproteins in the plasma.
COMMENT         The two small glycopeptides are present in a much higher
                concentration (5 times by weight) than the HMW glycoproteins
                but produce only a small depression effect. The exact
                physiological role of the small glycopeptides is not known.
KEYWORDS        glycoprotein
FEATURE
   3,6,9,12,15,18,21,
   24,27,30            #binding_site carbohydrate (Thr) (covalent) #status
                       experimental
SUMMARY         #length 31 #checksum 5375
SEQUENCE
                5        10        15        20        25        30
      1 A A T A A T A A T A A T A A T A A T A A T A A T A A T A A T
     31/A
///
ENTRY           A05161  #type complete
TITLE           antifreeze protein B precursor - winter flounder
ORGANISM        #formal_name Pseudopleuronectes americanus #common_name
                winter flounder
DATE            05-Jun-1987 #sequence_revision 05-Jun-1987 #text_change
                24-Oct-2000
ACCESSIONS      A05161
REFERENCE       A05161
   #authors     Davies, P.L.; Hough, C.; Scott, G.K.; Ng, N.; White, B.N.;
                Hew, C.L.
   #journal     J. Biol. Chem. (1984) 259:9241-9247
   #cross-references MUID:84264559; PMID:6086629
   #accession   A05161
      ##molecule_type DNA
      ##residues 1-82 ##label DAV
      ##cross-references GB:L00138; GB:J00929; NID:g343126; PIDN:AAB59964.1;
                PID:g457351
GENETICS
   #introns     19/2
CLASSIFICATION  #superfamily antifreeze protein
KEYWORDS        antifreeze
SUMMARY         #length 82  #molecular-weight 7755  #checksum 349
SEQUENCE
                5        10        15        20        25        30
      1 M A L S L F T V G Q L I F L F W T M R I T E A S P D P A A K
     31 A A P A A A A A P A A A A P D T A S D A A A A A A L T A A N
     61 A K A A A E L T A D N A A A A A A A T A R G
///
ENTRY           A05162  #type complete
TITLE           antifreeze protein SS-3 - shorthorn sculpin
ORGANISM        #formal_name Myoxocephalus scorpius #common_name shorthorn
                sculpin, daddy sculpin
DATE            05-Jun-1987 #sequence_revision 05-Jun-1987 #text_change
                24-Oct-2000
ACCESSIONS      A05162
REFERENCE       A91150
   #authors     Hew, C.L.; Joshi, S.; Wang, N.C.; Kao, M.H.;
                Ananthanarayanan, V.S.
   #journal     Eur. J. Biochem. (1985) 151:167-172
   #title       Structures of shorthorn sculpin antifreeze polypeptides.
   #cross-references MUID:85285003; PMID:4029130
   #accession   A05162
      ##molecule_type protein
      ##residues 1-33 ##label HEW
CLASSIFICATION  #superfamily antifreeze protein
KEYWORDS        antifreeze
SUMMARY         #length 33  #molecular-weight 2939  #checksum 8095
SEQUENCE
                5        10        15        20        25        30
      1 M N A P A R A A A K T A A D A L A A A K K T A A D A A A A A
     31 A A A
///
ENTRY           A05163  #type complete
TITLE           antifreeze protein SS-8 - shorthorn sculpin
ORGANISM        #formal_name Myoxocephalus scorpius #common_name shorthorn
                sculpin, daddy sculpin
DATE            05-Jun-1987 #sequence_revision 05-Jun-1987 #text_change
                24-Nov-1999
ACCESSIONS      A05163
REFERENCE       A91150
   #authors     Hew, C.L.; Joshi, S.; Wang, N.C.; Kao, M.H.;
                Ananthanarayanan, V.S.
   #journal     Eur. J. Biochem. (1985) 151:167-172
   #title       Structures of shorthorn sculpin antifreeze polypeptides.
   #cross-references MUID:85285003; PMID:4029130
   #accession   A05163
      ##molecule_type protein
      ##residues 1-45 ##label HEW
CLASSIFICATION  #superfamily antifreeze protein
KEYWORDS        antifreeze; blocked amino end; plasma
FEATURE
   9-45                #region alanine-rich\
   1                   #modified_site blocked amino end (Met) #status
                       experimental
SUMMARY         #length 45  #molecular-weight 4006  #checksum 777
SEQUENCE
                5        10        15        20        25        30
      1 M N G E T P A Q K A A R L A A A A A L A A K T A A D A A A K
     31 A A A K A A A I A A A A A S A
///
ENTRY           A22592  #type complete
TITLE           antifreeze protein IIA7 precursor - winter flounder
ORGANISM        #formal_name Pseudopleuronectes americanus #common_name
                winter flounder
DATE            05-Oct-1988 #sequence_revision 05-Oct-1988 #text_change
                24-Oct-2000
ACCESSIONS      A22592; S12604
REFERENCE       A22592
   #authors     Gourlie, B.; Lin, Y.; Price, J.; De Vries, A.L.; Powers, D.;
                Huang, R.C.C.
   #journal     J. Biol. Chem. (1984) 259:14960-14965
   #title       Winter flounder antifreeze proteins: a multigene family.
   #cross-references MUID:85054993; PMID:6548752
   #accession   A22592
      ##molecule_type mRNA
      ##residues 1-91 ##label GOU
      ##cross-references GB:M10148; NID:g213579; PIDN:AAA49465.1;
                PID:g213580
REFERENCE       S12604
   #authors     Gauthier, S.; Wu, Y.; Davies, P.L.
   #journal     Nucleic Acids Res. (1990) 18:5303
   #title       Nucleotide sequence of a variant antifreeze protein gene.
   #cross-references MUID:90384854; PMID:2402466
   #accession   S12604
      ##molecule_type DNA
      ##residues 1-63,'V',65-91 ##label GAU
      ##cross-references EMBL:X53718; NID:g64213; PIDN:CAA37754.1;
                PID:g3805952
GENETICS
   #introns     19/2
CLASSIFICATION  #superfamily antifreeze protein
KEYWORDS        antifreeze; tandem repeat
FEATURE
   1-21                #domain signal sequence #status predicted #label SIG\
   22-91               #product antifreeze protein IIA7 #status predicted
                       #label MAT
SUMMARY         #length 91  #molecular-weight 8326  #checksum 8524
SEQUENCE
                5        10        15        20        25        30
      1 M A L S L F T V G Q L I F L F W T M R I T E A N P D P A A K
     31 A V P A A A A P D T A S D A A A A A A A T A A T A A A A A A
     61 A T A A T A A K A A A L T A A N A A A A A A A T A A A A A R
     91 G
///
ENTRY           A25213  #type complete
TITLE           antifreeze glycoprotein 8R - saffron cod
ORGANISM        #formal_name Eleginus gracilis #common_name saffron cod
DATE            19-Nov-1988 #sequence_revision 19-Nov-1988 #text_change
                31-Dec-1993
ACCESSIONS      A25213
REFERENCE       A92586
   #authors     Burcham, T.S.; Osuga, D.T.; Rao, B.N.N.; Bush, C.A.; Feeney,
                R.E.
   #journal     J. Biol. Chem. (1986) 261:6384-6389
   #title       Purification and primary sequences of the major
                arginine-containing antifreeze glycopeptides from the fish
                Eleginus gracilis.
   #cross-references MUID:86196057; PMID:3700395
   #accession   A25213
      ##molecule_type protein
      ##residues 1-16 ##label BUR
KEYWORDS        glycoprotein
SUMMARY         #length 16  #molecular-weight 1413  #checksum 9965
SEQUENCE
                5        10        15        20        25        30
      1 A A T A A T P A T A A T P A R A
///
ENTRY           A30238  #type complete
TITLE           antifreeze proteins - Atlantic wolffish
ORGANISM        #formal_name Anarhichas lupus #common_name Atlantic wolffish
DATE            01-Dec-1989 #sequence_revision 30-Sep-1991 #text_change
                24-Oct-2000
ACCESSIONS      A30238; B30238
REFERENCE       A30238
   #authors     Scott, G.K.; Hayes, P.H.; Fletcher, G.L.; Davies, P.L.
   #journal     Mol. Cell. Biol. (1988) 8:3670-3675
   #title       Wolffish antifreeze protein genes are primarily organized as
                tandem repeats that each contain two genes in inverted
                orientation.
   #cross-references MUID:89127205; PMID:2851724
   #accession   A30238
      ##molecule_type DNA
      ##residues 1-88 ##label SC1
      ##cross-references GB:M22125; NID:g210958; PIDN:AAA74890.1;
                PID:g210959
   #accession   B30238
      ##molecule_type DNA
      ##residues 1-68,'A',70-88 ##label SC2
      ##cross-references GB:M22125
      ##note the authors translated the codon GAC for residue 17 as Asp, CTG
                for residue 19 as Met, and CAA for residue 60 as ASN
CLASSIFICATION  #superfamily antifreeze protein SP1
KEYWORDS        antifreeze
SUMMARY         #length 88  #molecular-weight 9438  #checksum 4282
SEQUENCE
                5        10        15        20        25        30
      1 M K S A I L T G L L F V L L C V D H L S S A S Q S V V A T Q
     31 L I P I N T A L T P I M M K G Q V V N P A G I P F A E M S Q
     61 I V G K Q V N R P V A K D E T L M P N M V K T Y R A A K
///
ENTRY           A30839  #type fragment
TITLE           antifreeze protein 12 - ocean pout (fragment)
ORGANISM        #formal_name Macrozoarces americanus #common_name ocean pout
DATE            28-Feb-1990 #sequence_revision 28-Feb-1990 #text_change
                24-Oct-2000
ACCESSIONS      A30839
REFERENCE       A31075
   #authors     Hew, C.L.; Wang, N.C.; Joshi, S.; Fletcher, G.L.; Scott,
                G.K.; Hayes, P.H.; Buettner, B.; Davies, P.L.
   #journal     J. Biol. Chem. (1988) 263:12049-12055
   #title       Multiple genes provide the basis for antifreeze protein
                diversity and dosage in the ocean pout, Macrozoarces
                americanus.
   #cross-references MUID:88298890; PMID:3403560
   #accession   A30839
      ##molecule_type protein
      ##residues 1-66 ##label HEW
CLASSIFICATION  #superfamily antifreeze protein SP1
KEYWORDS        antifreeze
SUMMARY         #length 66 #checksum 2901
SEQUENCE
                5        10        15        20        25        30
      1/N Q A S V V A N Q L I P I N T A L T L V M M R S E V V T P V
     31 G I P A E D I P R L V S M Q V N R A V P L G T T L M P D M V
     61 K G Y P P A/
///
ENTRY           A31075  #type complete
TITLE           antifreeze protein c10 precursor - ocean pout
ORGANISM        #formal_name Macrozoarces americanus #common_name ocean pout
DATE            28-Feb-1990 #sequence_revision 28-Feb-1990 #text_change
                24-Oct-2000
ACCESSIONS      A31075
REFERENCE       A31075
   #authors     Hew, C.L.; Wang, N.C.; Joshi, S.; Fletcher, G.L.; Scott,
                G.K.; Hayes, P.H.; Buettner, B.; Davies, P.L.
   #journal     J. Biol. Chem. (1988) 263:12049-12055
   #title       Multiple genes provide the basis for antifreeze protein
                diversity and dosage in the ocean pout, Macrozoarces
                americanus.
   #cross-references MUID:88298890; PMID:3403560
   #accession   A31075
      ##molecule_type mRNA
      ##residues 1-87 ##label HEW
      ##cross-references GB:M11790
CLASSIFICATION  #superfamily antifreeze protein SP1
KEYWORDS        antifreeze
SUMMARY         #length 87  #molecular-weight 9306  #checksum 2187
SEQUENCE
                5        10        15        20        25        30
      1 M K S V I L T G L L F V L L C V D H M T A S Q S V V A T Q L
     31 I P M N S A L T P V M M E G K V T N P I G I P F A E M S Q M
     61 V G K Q V N R P V A K G Q T I M P N M V K T Y A A G K
///
ENTRY           A34313  #type complete
TITLE           antifreeze protein II precursor - sea raven
ALTERNATE_NAMES pro-antifreeze protein type II
ORGANISM        #formal_name Hemitripterus americanus #common_name sea raven
DATE            10-Sep-1999 #sequence_revision 10-Sep-1999 #text_change
                10-Sep-1999
ACCESSIONS      A34313; A24602; PC2386; PC2387; S65733
REFERENCE       A34313
   #authors     Hayes, P.H.; Scott, G.K.; Ng, N.F.L.; Hew, C.L.; Davies,
                P.L.
   #journal     J. Biol. Chem. (1989) 264:18761-18767
   #title       Cystine-rich type II antifreeze protein precursor is
                initiated from the third AUG codon of its mRNA.
   #cross-references MUID:90036986; PMID:2572595
   #accession   A34313
      ##molecule_type DNA; mRNA
      ##residues 1-37,'G',39-163 ##label HAY
      ##cross-references GB:J05100; NID:g213875; PIDN:AAA49618.1;
                PID:g213876
      ##note there are 12-15 copies in the genome; the sequence of SR7 was
                determined
      ##note the initiator codon was determined
      ##note parts of this sequence, including the amino end of the mature
                protein, were determined by protein sequencing
      ##note the amino end of the mature protein is blocked
REFERENCE       A24602
   #authors     Ng, N.F.; Trinh, K.Y.; Hew, C.L.
   #journal     J. Biol. Chem. (1986) 261:15690-15695
   #title       Structure of an antifreeze polypeptide precursor from the
                sea raven, Hemitripterus americanus.
   #cross-references MUID:87057207; PMID:3782083
   #accession   A24602
      ##molecule_type mRNA
      ##residues 'MQRQQADTETREDISTAGLSIIFIVCTISTTR',1-163 ##label NGN
      ##cross-references GB:J02593; NID:g213873; PIDN:AAA49617.1;
                PID:g213874
      ##note parts of this sequence were determined by protein sequencing
REFERENCE       PC2386
   #authors     Duncker, B.P.; Gauthier, S.Y.; Davies, P.L.
   #journal     Biochem. Biophys. Res. Commun. (1994) 203:1851-1857
   #title       Cystine-rich fish antifreeze is produced as an active
                proprotein precursor in fall armyworm cells.
   #cross-references MUID:95032070; PMID:7945337
   #accession   PC2386
      ##molecule_type mRNA
      ##residues 1-45 ##label DUN
   #accession   PC2387
      ##molecule_type protein
      ##residues 18-27 ##label DU2
REFERENCE       S65733
   #authors     Duncker, B.P.; Gauthier, S.Y.; Davies, P.L.
   #journal     Biochim. Biophys. Acta (1996) 1292:312-316
   #title       Evidence for a proprotein intermediate during maturation of
                type II antifreeze protein in sea raven, Hemitripterus
                americanus.
   #cross-references MUID:96176860; PMID:8597578
   #accession   S65733
      ##molecule_type protein
      ##residues 18-22 ##label DUW
GENETICS
   #introns     21/1; 66/3; 105/3; 142/1
CLASSIFICATION  #superfamily tetranectin; C-type lectin homology
KEYWORDS        pyroglutamic acid
FEATURE
   1-17                #domain signal sequence #status predicted #label SIG\
   18-34               #domain propeptide #status experimental #label PRO\
   35-163              #product antifreeze protein II #status predicted
                       #label MAT\
   41-159              #domain C-type lectin homology #label LCH\
   35                  #modified_site pyrrolidone carboxylic acid (Gln) (in
                       mature form) #status experimental\
   41-52,69-159,
   135-151             #disulfide_bonds #status predicted
SUMMARY         #length 163  #molecular-weight 17509  #checksum 1944
SEQUENCE
                5        10        15        20        25        30
      1 M L T V S L L V C A M M A L T Q A N D D K I L K G T A T E A
     31 G P V S Q R A P P N C P A G W Q P L G D R C I Y Y E T T A M
     61 T W A L A E T N C M K L G G H L A S I H S Q E E H S F I Q T
     91 L N A G V V W I G G S A C L Q A G A W T W S D G T P M N F R
    121 S W C S T K P D D V L A A C C M Q M T A A A D Q C W D D L P
    151 C P A S H K S V C A M T F
///
ENTRY           A38420  #type complete
TITLE           antifreeze glycoprotein precursor - black rockcod
ORGANISM        #formal_name Notothenia coriiceps neglecta #common_name
                black rockcod
DATE            28-Jun-1991 #sequence_revision 30-Jan-1993 #text_change
                09-Sep-1997
ACCESSIONS      A38420
REFERENCE       A38420
   #authors     Hsiao, K.C.; Cheng, C.H.C.; Fernandes, I.E.; Detrich, H.W.;
                DeVries, A.L.
   #journal     Proc. Natl. Acad. Sci. U.S.A. (1990) 87:9265-9269
   #title       An antifreeze glycopeptide gene from the antarctic cod
                Notothenia coriiceps neglecta encodes a polyprotein of high
                peptide copy number.
   #cross-references MUID:91067687; PMID:2251271
   #accession   A38420
      ##status preliminary
      ##molecule_type DNA
      ##residues 1-822 ##label HSI
      ##cross-references GB:M55000; NID:g213391; PID:g213392
      ##note the authors translated the codon CCT for residue 489 as Ala
KEYWORDS        glycoprotein
SUMMARY         #length 822  #molecular-weight 74669  #checksum 6246
SEQUENCE
                5        10        15        20        25        30
      1 M F V V E D N K C I S F S V C V C V C V C V C V S V C V C E
     31 T A V T A A P A A T A A T A A T P A T A A L N F A A T A A T
     61 P A T P A T P A L I F A A T A A T A A T P A T A A L N F A A
     91 T A A T P A T A A T P A L I F A A A A A T A A T P A T A A L
    121 N F A A T A A T P A T A A T P A L I F A A T A A T A A T P A
    151 T P A F H F A A T A A T P A T A A T P A L I F A A T A A T A
    181 A T P A T P A F H F A A T A A T P A T A A T P A L I F A A T
    211 A A T A A T P A T A A L N F A A T A A T P A T A A T P A L I
    241 F A A T A A T A A T P A T A A L N F A A T A A T A A T P A T
    271 A A C N F A A T A A T P A T A A T P A L I F A A T A A T A A
    301 T P A T A A C N F A A T A A T P A T A A T P A L I F A A T A
    331 A T A A T P A T A A L N F A A T A A T P A T A A T P A L I F
    361 A A T A A T A A T P A T A A L N F A A T A A T P A T A A T P
    391 A L I F A A T A A T A A T P A T A A L N F A A T A A T A A T
    421 P A T P A F N F A A T A A T P A T A A T P A L I F A A T A A
    451 T A A T P A T A A L N F A A T A A T P A T A A T P A L I F A
    481 A T A A T A A T P A T A A L H F A A T A A T A A T P A T A A
    511 L N F A A T A A T P A T A A T P A L I F A A T A A T A A T P
    541 A T A A F N F A A T A A T A A T P A T A A L N F A A T A A T
    571 P A T A A T P A L I F A A T A A T A A T P A T A A L N F A A
    601 T A A T P A T A A T P A L I F A A T A A T A A T P A T P A F
    631 H F A A T A A T P A T A A T P A L I F A A T A A T A A T P A
    661 T A A L N F A A T A A T A A T P A T A A L N F A A T A A T P
    691 A T A A T P A L I F A A T A A T A A T P A T A A L N F A A T
    721 A A T P A T A A T P A L I F A A T A A T A A T P A T A A F N
    751 F A A T A A T A A T P A T A A T P A L I F A A T A A T A A T
    781 P A T P A T P A L I F A A T A A T A A T P A T P A L N F A A
    811 T A A T A A T T A A R G
///
ENTRY           A59010  #type complete
TITLE           antifreeze protein LS-12 - longhorn sculpin
ORGANISM        #formal_name Myoxocephalus octodecimspinosis #common_name
                longhorn sculpin
DATE            10-Oct-1997 #sequence_revision 10-Oct-1997 #text_change
                07-May-1999
ACCESSIONS      A59010
REFERENCE       A59010
   #authors     Deng, G.; Andrews, D.W.; Laursen, R.A.
   #journal     FEBS Lett. (1997) 402:17-20
   #cross-references MUID:97165956; PMID:9013849
   #accession   A59010
      ##status preliminary
      ##molecule_type protein
      ##residues 1-108 ##label LAU
      ##experimental_source blood plasma
KEYWORDS        antifreeze; plasma; pyroglutamic acid
FEATURE
   1                   #modified_site pyrrolidone carboxylic acid (Gln)
                       #status experimental
SUMMARY         #length 108  #molecular-weight 12315  #checksum 5099
SEQUENCE
                5        10        15        20        25        30
      1 Q G A A D L E S L G Q Y F E E M K T K L I Q D M T E I I R S
     31 Q D L A N Q A Q A F V E D K K T Q L Q P L V A Q I Q E Q M K
     61 T V A T N V E E Q I R P L T A N V Q A H L Q P Q I D N F Q K
     91 Q M E A I I K K L T D Q T M A I E N
///
ENTRY           B25213  #type complete
TITLE           antifreeze glycoprotein 7R - saffron cod
ORGANISM        #formal_name Eleginus gracilis #common_name saffron cod
DATE            19-Nov-1988 #sequence_revision 19-Nov-1988 #text_change
                31-Dec-1993
ACCESSIONS      B25213
REFERENCE       A92586
   #authors     Burcham, T.S.; Osuga, D.T.; Rao, B.N.N.; Bush, C.A.; Feeney,
                R.E.
   #journal     J. Biol. Chem. (1986) 261:6384-6389
   #title       Purification and primary sequences of the major
                arginine-containing antifreeze glycopeptides from the fish
                Eleginus gracilis.
   #cross-references MUID:86196057; PMID:3700395
   #accession   B25213
      ##molecule_type protein
      ##residues 1-19 ##label BUR
KEYWORDS        glycoprotein
SUMMARY         #length 19  #molecular-weight 1656  #checksum 3811
SEQUENCE
                5        10        15        20        25        30
      1 A A T A A T P A T A A T P A T A A R A
///
ENTRY           B30839  #type complete
TITLE           antifreeze protein lambda-3 precursor - ocean pout
ORGANISM        #formal_name Macrozoarces americanus #common_name ocean pout
DATE            28-Feb-1990 #sequence_revision 28-Feb-1990 #text_change
                24-Oct-2000
ACCESSIONS      B30839
REFERENCE       A31075
   #authors     Hew, C.L.; Wang, N.C.; Joshi, S.; Fletcher, G.L.; Scott,
                G.K.; Hayes, P.H.; Buettner, B.; Davies, P.L.
   #journal     J. Biol. Chem. (1988) 263:12049-12055
   #title       Multiple genes provide the basis for antifreeze protein
                diversity and dosage in the ocean pout, Macrozoarces
                americanus.
   #cross-references MUID:88298890; PMID:3403560
   #accession   B30839
      ##molecule_type DNA
      ##residues 1-91 ##label HEW
      ##cross-references GB:J03923; GB:J03924; NID:g213364; PIDN:AAA49348.1;
                PID:g213365
CLASSIFICATION  #superfamily antifreeze protein SP1
KEYWORDS        antifreeze
SUMMARY         #length 91  #molecular-weight 9912  #checksum 3641
SEQUENCE
                5        10        15        20        25        30
      1 M K S V I L T G L L F V L L C V D H M S S A N Q S V V A T Q
     31 L I P I N T A L T L V M M T T R V I Y P T G I P A E D I P R
     61 L V S M Q V N Q A V P M G T T L M P D M V K F Y C L C A P K
     91 N
///
ENTRY           B31075  #type complete
TITLE           antifreeze protein c7 precursor - ocean pout
ORGANISM        #formal_name Macrozoarces americanus #common_name ocean pout
DATE            28-Feb-1990 #sequence_revision 28-Feb-1990 #text_change
                24-Oct-2000
ACCESSIONS      B31075
REFERENCE       A31075
   #authors     Hew, C.L.; Wang, N.C.; Joshi, S.; Fletcher, G.L.; Scott,
                G.K.; Hayes, P.H.; Buettner, B.; Davies, P.L.
   #journal     J. Biol. Chem. (1988) 263:12049-12055
   #title       Multiple genes provide the basis for antifreeze protein
                diversity and dosage in the ocean pout, Macrozoarces
                americanus.
   #cross-references MUID:88298890; PMID:3403560
   #accession   B31075
      ##molecule_type mRNA
      ##residues 1-87 ##label HEW
      ##cross-references GB:M11790
CLASSIFICATION  #superfamily antifreeze protein SP1
KEYWORDS        antifreeze
SUMMARY         #length 87  #molecular-weight 9229  #checksum 2098
SEQUENCE
                5        10        15        20        25        30
      1 M K S V I L T G L L F V L L C V D H M T A S Q S V V A T Q L
     31 I P I N T A L T P V M M E G K V T N P I G I P F A E M S Q I
     61 V G K Q V N T P V A K G Q T I M P N M V K T Y A A G K
///
ENTRY           C31075  #type complete
TITLE           antifreeze protein lambda-5 precursor - ocean pout
ORGANISM        #formal_name Macrozoarces americanus #common_name ocean pout
DATE            28-Feb-1990 #sequence_revision 28-Feb-1990 #text_change
                24-Oct-2000
ACCESSIONS      C31075
REFERENCE       A31075
   #authors     Hew, C.L.; Wang, N.C.; Joshi, S.; Fletcher, G.L.; Scott,
                G.K.; Hayes, P.H.; Buettner, B.; Davies, P.L.
   #journal     J. Biol. Chem. (1988) 263:12049-12055
   #title       Multiple genes provide the basis for antifreeze protein
                diversity and dosage in the ocean pout, Macrozoarces
                americanus.
   #cross-references MUID:88298890; PMID:3403560
   #accession   C31075
      ##molecule_type DNA
      ##residues 1-87 ##label HEW
      ##cross-references GB:J03921
CLASSIFICATION  #superfamily antifreeze protein SP1
KEYWORDS        antifreeze
SUMMARY         #length 87  #molecular-weight 9229  #checksum 2152
SEQUENCE
                5        10        15        20        25        30
      1 M K S V I L T G L L F V L L C V D H M T A S Q S V V A T Q L
     31 I P I N T A L T P V M M E G K V T N P I G I P F A E M S Q I
     61 V G K Q V N T P V A K G Q T L M P N M V K T Y A A G K
///
ENTRY           D31075  #type fragment
TITLE           antifreeze protein 1 - ocean pout (fragment)
ORGANISM        #formal_name Macrozoarces americanus #common_name ocean pout
DATE            28-Feb-1990 #sequence_revision 28-Feb-1990 #text_change
                24-Oct-2000
ACCESSIONS      D31075
REFERENCE       A31075
   #authors     Hew, C.L.; Wang, N.C.; Joshi, S.; Fletcher, G.L.; Scott,
                G.K.; Hayes, P.H.; Buettner, B.; Davies, P.L.
   #journal     J. Biol. Chem. (1988) 263:12049-12055
   #title       Multiple genes provide the basis for antifreeze protein
                diversity and dosage in the ocean pout, Macrozoarces
                americanus.
   #cross-references MUID:88298890; PMID:3403560
   #accession   D31075
      ##molecule_type protein
      ##residues 1-64 ##label HEW
CLASSIFICATION  #superfamily antifreeze protein SP1
KEYWORDS        antifreeze
SUMMARY         #length 64 #checksum 9
SEQUENCE
                5        10        15        20        25        30
      1/S Q S V V A T Q L I P M N T A L T P V M M E G K V T N P I G
     31 I P F A E M S Q I V G K Q V N T P V A K G Q T I M P N M V K
     61 T Y A A/
///
ENTRY           E31075  #type fragment
TITLE           antifreeze protein 4 - ocean pout (fragment)
ORGANISM        #formal_name Macrozoarces americanus #common_name ocean pout
DATE            28-Feb-1990 #sequence_revision 28-Feb-1990 #text_change
                24-Oct-2000
ACCESSIONS      E31075
REFERENCE       A31075
   #authors     Hew, C.L.; Wang, N.C.; Joshi, S.; Fletcher, G.L.; Scott,
                G.K.; Hayes, P.H.; Buettner, B.; Davies, P.L.
   #journal     J. Biol. Chem. (1988) 263:12049-12055
   #title       Multiple genes provide the basis for antifreeze protein
                diversity and dosage in the ocean pout, Macrozoarces
                americanus.
   #cross-references MUID:88298890; PMID:3403560
   #accession   E31075
      ##molecule_type protein
      ##residues 1-63 ##label HEW
CLASSIFICATION  #superfamily antifreeze protein SP1
KEYWORDS        antifreeze
SUMMARY         #length 63 #checksum 9004
SEQUENCE
                5        10        15        20        25        30
      1/Q S V V A T Q L I P I N T A L T P A M M E G K V T N P I G I
     31 P F A E M S Q I V G K Q V N T P V A K G Q T I M P N M V K T
     61 Y A A/
///
ENTRY           FDFI5G  #type complete
TITLE           antifreeze protein GS-5 - grubby sculpin
ORGANISM        #formal_name Myoxocephalus aenaeus #common_name grubby
                sculpin
DATE            31-Dec-1990 #sequence_revision 31-Dec-1990 #text_change
                24-Nov-1999
ACCESSIONS      S06417
REFERENCE       S06417
   #authors     Chakrabartty, A.; Hew, C.L.; Shears, M.; Fletcher, G.
   #journal     Can. J. Zool. (1988) 66:403-408
   #title       Primary structures of the alanine-rich antifreeze
                polypeptides from grubby sculpin, Myoxocephalus aenaeus.
   #accession   S06417
      ##molecule_type protein
      ##residues 1-33 ##label CHA
CLASSIFICATION  #superfamily antifreeze protein
KEYWORDS        antifreeze; blocked amino end
FEATURE
   1                   #modified_site blocked amino end (Met) #status
                       experimental
SUMMARY         #length 33  #molecular-weight 2980  #checksum 8836
SEQUENCE
                5        10        15        20        25        30
      1 M D A P A I A A A K T A A D A L A A A K K T A A D A A A A A
     31 A K P
///
ENTRY           FDFI8G  #type complete
TITLE           antifreeze protein GS-8 - grubby sculpin
ORGANISM        #formal_name Myoxocephalus aenaeus #common_name grubby
                sculpin
DATE            31-Dec-1990 #sequence_revision 31-Dec-1990 #text_change
                24-Nov-1999
ACCESSIONS      S07046
REFERENCE       S06417
   #authors     Chakrabartty, A.; Hew, C.L.; Shears, M.; Fletcher, G.
   #journal     Can. J. Zool. (1988) 66:403-408
   #title       Primary structures of the alanine-rich antifreeze
                polypeptides from grubby sculpin, Myoxocephalus aenaeus.
   #accession   S07046
      ##molecule_type protein
      ##residues 1-40 ##label CHA
CLASSIFICATION  #superfamily antifreeze protein
KEYWORDS        antifreeze; blocked amino end
FEATURE
   1                   #modified_site blocked amino end (Met) #status
                       experimental
SUMMARY         #length 40  #molecular-weight 3579  #checksum 5679
SEQUENCE
                5        10        15        20        25        30
      1 M D G E T P A Q K A A R L A A A A A A L A A K T A A D A A A
     31 K A A A I A A A A A
///
ENTRY           FDFICP  #type complete
TITLE           antifreeze protein SP1-C precursor - ocean pout
ORGANISM        #formal_name Macrozoarces americanus #common_name ocean pout
DATE            31-Mar-1988 #sequence_revision 31-Mar-1988 #text_change
                22-Jun-1999
ACCESSIONS      A24081; F31075
REFERENCE       A24081
   #authors     Li, X.M.; Trinh, K.Y.; Hew, C.L.; Buettner, B.; Baenziger,
                J.; Davies, P.L.
   #journal     J. Biol. Chem. (1985) 260:12904-12909
   #title       Structure of an antifreeze polypeptide and its precursor
                from the ocean pout, Macrozoarces americanus.
   #cross-references MUID:86033715; PMID:3840475
   #accession   A24081
      ##molecule_type mRNA
      ##residues 1-87 ##label LIX
      ##cross-references GB:M11790; NID:g213362; PIDN:AAA49347.1;
                PID:g213363
REFERENCE       A31075
   #authors     Hew, C.L.; Wang, N.C.; Joshi, S.; Fletcher, G.L.; Scott,
                G.K.; Hayes, P.H.; Buettner, B.; Davies, P.L.
   #journal     J. Biol. Chem. (1988) 263:12049-12055
   #title       Multiple genes provide the basis for antifreeze protein
                diversity and dosage in the ocean pout, Macrozoarces
                americanus.
   #cross-references MUID:88298890; PMID:3403560
   #accession   F31075
      ##molecule_type protein
      ##residues 23-86 ##label HEW
COMMENT         Ocean pout AFP has at least 12 components, which separate
                into SP1, SP2, SP3, and SP4 in ion-exchange chromatography.
                SP1 has 3 components; SP1-A, SP1-B and SP1-C. SP1-A differs
                from that shown at least in having 75-Ile and 84-Ala. SP1-B
                may be a posttranslational modification of SP1-C.
CLASSIFICATION  #superfamily antifreeze protein SP1
KEYWORDS        antifreeze; plasma; pyroglutamic acid
FEATURE
   1-22                #domain signal sequence #status predicted #label SIG\
   23-87               #product antifreeze protein SP1-C #status
                       experimental #label AFC\
   23                  #modified_site pyrrolidone carboxylic acid (Gln) (in
                       mature form) #status experimental
SUMMARY         #length 87  #molecular-weight 9229  #checksum 1879
SEQUENCE
                5        10        15        20        25        30
      1 M K S V I L T G L L F V L L C V D H M T A S Q S V V A T Q L
     31 I P I N T A L T P A M M E G K V T N P I G I P F A E M S Q I
     61 V G K Q V N T P V A K G Q T L M P N M V K T Y V A G K
///
ENTRY           FDFILC  #type complete
TITLE           antifreeze protein LP - Canadian eelpout
ORGANISM        #formal_name Lycodes polaris #common_name Canadian eelpout
DATE            30-Sep-1991 #sequence_revision 30-Sep-1991 #text_change
                30-Jun-1993
ACCESSIONS      S07150
REFERENCE       S07150
   #authors     Schrag, J.D.; Cheng, C.H.C.; Panico, M.; Morris, H.R.;
                DeVries, A.L.
   #journal     Biochim. Biophys. Acta (1987) 915:357-370
   #title       Primary and secondary structure of antifreeze peptides from
                arctic and antarctic zoarcid fishes.
   #cross-references MUID:88000728; PMID:3477289
   #accession   S07150
      ##molecule_type protein
      ##residues 1-66 ##label SCH
CLASSIFICATION  #superfamily antifreeze protein SP1
KEYWORDS        antifreeze
SUMMARY         #length 66  #molecular-weight 6982  #checksum 966
SEQUENCE
                5        10        15        20        25        30
      1 N K A S V V A N Q L I P I N T A L T L V M M R A E V V T P A
     31 G I P A E D I P R L V G L Q V N R A V L I G T T L M P D M V
     61 K G Y A P Q
///
ENTRY           FDFIRE  #type complete
TITLE           antifreeze protein RD2 - eelpout (Lycodichthys dearborni)
ORGANISM        #formal_name Lycodichthys dearborni
DATE            30-Sep-1991 #sequence_revision 30-Sep-1991 #text_change
                26-Feb-1999
ACCESSIONS      S08561; S53513
REFERENCE       S07150
   #authors     Schrag, J.D.; Cheng, C.H.C.; Panico, M.; Morris, H.R.;
                DeVries, A.L.
   #journal     Biochim. Biophys. Acta (1987) 915:357-370
   #title       Primary and secondary structure of antifreeze peptides from
                arctic and antarctic zoarcid fishes.
   #cross-references MUID:88000728; PMID:3477289
   #accession   S08561
      ##molecule_type protein
      ##residues 1-64 ##label SCH
      ##note the source is designated as Rhigophila dearborni
REFERENCE       S53512
   #authors     Wang, X.; DeVries, A.L.; Cheng, C.H.C.
   #journal     Biochim. Biophys. Acta (1995) 1247:163-172
   #title       Antifreeze peptide heterogeneity in an antarctic eel pout
                includes an unusually large major variant comprised of two 7
                kDa type III AFPs linked in tandem.
   #cross-references MUID:95210308; PMID:7696304
   #accession   S53513
      ##status preliminary
      ##molecule_type protein
      ##residues 1-64 ##label WAN
CLASSIFICATION  #superfamily antifreeze protein SP1
KEYWORDS        antifreeze
SUMMARY         #length 64  #molecular-weight 6934  #checksum 9342
SEQUENCE
                5        10        15        20        25        30
      1 N K A S V V A N Q L I P I N T A L T L I M M K A E V V T P M
     31 G I P A E D I P R I I G M Q V N R A V P L G T T L M P D M V
     61 K N Y E
///
ENTRY           FDFL3W  #type complete
TITLE           antifreeze protein 3 - winter flounder
ORGANISM        #formal_name Pseudopleuronectes americanus #common_name
                winter flounder
DATE            01-Sep-1981 #sequence_revision 01-Sep-1981 #text_change
                23-Aug-1996
ACCESSIONS      A03192
REFERENCE       A03192
   #authors     DeVries, A.L.; Lin, Y.
   #journal     Biochim. Biophys. Acta (1977) 495:388-392
   #title       Structure of a peptide antifreeze and mechanism of
                adsorption to ice.
   #cross-references MUID:78060969; PMID:588591
   #accession   A03192
      ##molecule_type protein
      ##residues 1-37 ##label DEV
CLASSIFICATION  #superfamily antifreeze protein
KEYWORDS        antifreeze
SUMMARY         #length 37  #molecular-weight 3144  #checksum 7865
SEQUENCE
                5        10        15        20        25        30
      1 D T A S D A A A A A A L T A A B A A A A A K L T A B B A A A
     31 A A A A T A A
///
ENTRY           FDFL4W  #type complete
TITLE           antifreeze protein 4 precursor - winter flounder
ORGANISM        #formal_name Pseudopleuronectes americanus #common_name
                winter flounder
DATE            01-Sep-1981 #sequence_revision 01-Sep-1981 #text_change
                25-Apr-1997
ACCESSIONS      A03193
REFERENCE       A03193
   #authors     Lin, Y.; Gross, J.K.
   #journal     Proc. Natl. Acad. Sci. U.S.A. (1981) 78:2825-2829
   #title       Molecular cloning and characterization of winter flounder
                antifreeze cDNA.
   #cross-references MUID:81247379; PMID:6265915
   #accession   A03193
      ##molecule_type mRNA
      ##residues 1-85 ##label LIN
CLASSIFICATION  #superfamily antifreeze protein
KEYWORDS        antifreeze
FEATURE
   1-21                #domain signal sequence #status predicted #label SIG\
   22-85               #product antifreeze protein 4 #status predicted
                       #label MAT
SUMMARY         #length 85  #molecular-weight 7243  #checksum 2205
SEQUENCE
                5        10        15        20        25        30
      1 M R I T E A N P D P D A K A V P A A A A P D T A S D A A A A
     31 A A A T A A T A A A A A A A T A A T A A A A A A A T A A T A
     61 A K A A A L T A A N A A A A A A A T A A A A A R G
///
ENTRY           FDFLAW  #type complete
TITLE           antifreeze protein A precursor - winter flounder
ORGANISM        #formal_name Pseudopleuronectes americanus #common_name
                winter flounder
DATE            13-Aug-1986 #sequence_revision 13-Aug-1986 #text_change
                22-Jun-1999
ACCESSIONS      JS0704; A03194
REFERENCE       JH0627
   #authors     Davies, P.L.
   #journal     Gene (1992) 112:163-170
   #title       Conservation of antifreeze protein-encoding genes in tandem
                repeats.
   #cross-references MUID:92209995; PMID:1555765
   #accession   JS0704
      ##molecule_type DNA
      ##residues 1-82 ##label DA1
      ##cross-references GB:M62412; GB:M62416; NID:g213592; PIDN:AAA49471.1;
                PID:g213593
REFERENCE       A03194
   #authors     Davies, P.L.; Roach, A.H.; Hew, C.L.
   #journal     Proc. Natl. Acad. Sci. U.S.A. (1982) 79:335-339
   #title       DNA sequence coding for an antifreeze protein precursor from
                winter flounder.
   #cross-references MUID:82197490; PMID:6952188
   #accession   A03194
      ##molecule_type mRNA
      ##residues 1-82 ##label DA2
      ##experimental_source clones 4-2b and 2A-7c
      ##note the authors translated the codon AGC for residue 24 as Arg
GENETICS
   #introns     19/2
CLASSIFICATION  #superfamily antifreeze protein
KEYWORDS        antifreeze; plasma; tandem repeat
FEATURE
   1-21                #domain signal sequence #status predicted #label SIG\
   22-44               #domain propeptide #status predicted #label PRO\
   45-82               #product antifreeze protein A #status predicted
                       #label MAT
SUMMARY         #length 82  #molecular-weight 7711  #checksum 310
SEQUENCE
                5        10        15        20        25        30
      1 M A L S L F T V G Q L I F L F W T M R I T E A S P D P A A K
     31 A A P A A A A A P A A A A P D T A S D A A A A A A L T A A N
     61 A K A A A E L T A A N A A A A A A A T A R G
///
ENTRY           G31075  #type fragment
TITLE           antifreeze protein 7 - ocean pout (fragment)
ORGANISM        #formal_name Macrozoarces americanus #common_name ocean pout
DATE            28-Feb-1990 #sequence_revision 28-Feb-1990 #text_change
                24-Oct-2000
ACCESSIONS      G31075
REFERENCE       A31075
   #authors     Hew, C.L.; Wang, N.C.; Joshi, S.; Fletcher, G.L.; Scott,
                G.K.; Hayes, P.H.; Buettner, B.; Davies, P.L.
   #journal     J. Biol. Chem. (1988) 263:12049-12055
   #title       Multiple genes provide the basis for antifreeze protein
                diversity and dosage in the ocean pout, Macrozoarces
                americanus.
   #cross-references MUID:88298890; PMID:3403560
   #accession   G31075
      ##molecule_type protein
      ##residues 1-64 ##label HEW
CLASSIFICATION  #superfamily antifreeze protein SP1
KEYWORDS        antifreeze
SUMMARY         #length 64 #checksum 9359
SEQUENCE
                5        10        15        20        25        30
      1/S Q S V V A T R L I P M N T A L T P A M M E G K V T N P I G
     31 I P F A E M S Q I V G K Q V N R I V A K G Q T L M P N M V K
     61 T Y A A/
///
ENTRY           H31075  #type fragment
TITLE           antifreeze protein 9 - ocean pout (fragment)
ORGANISM        #formal_name Macrozoarces americanus #common_name ocean pout
DATE            28-Feb-1990 #sequence_revision 28-Feb-1990 #text_change
                24-Oct-2000
ACCESSIONS      H31075
REFERENCE       A31075
   #authors     Hew, C.L.; Wang, N.C.; Joshi, S.; Fletcher, G.L.; Scott,
                G.K.; Hayes, P.H.; Buettner, B.; Davies, P.L.
   #journal     J. Biol. Chem. (1988) 263:12049-12055
   #title       Multiple genes provide the basis for antifreeze protein
                diversity and dosage in the ocean pout, Macrozoarces
                americanus.
   #cross-references MUID:88298890; PMID:3403560
   #accession   H31075
      ##molecule_type protein
      ##residues 1-64 ##label HEW
CLASSIFICATION  #superfamily antifreeze protein SP1
KEYWORDS        antifreeze
SUMMARY         #length 64 #checksum 9351
SEQUENCE
                5        10        15        20        25        30
      1/S Q S V V A T Q L I P M N T A L T P A M M E G K V T N P I G
     31 I P F A E M S Q I V G K Q V N R I V A K G Q T L M P N M V K
     61 T Y A A/
///
ENTRY           I31075  #type fragment
TITLE           antifreeze protein 11 - ocean pout (fragment)
ORGANISM        #formal_name Macrozoarces americanus #common_name ocean pout
DATE            28-Feb-1990 #sequence_revision 28-Feb-1990 #text_change
                24-Oct-2000
ACCESSIONS      I31075
REFERENCE       A31075
   #authors     Hew, C.L.; Wang, N.C.; Joshi, S.; Fletcher, G.L.; Scott,
                G.K.; Hayes, P.H.; Buettner, B.; Davies, P.L.
   #journal     J. Biol. Chem. (1988) 263:12049-12055
   #title       Multiple genes provide the basis for antifreeze protein
                diversity and dosage in the ocean pout, Macrozoarces
                americanus.
   #cross-references MUID:88298890; PMID:3403560
   #accession   I31075
      ##molecule_type protein
      ##residues 1-62 ##label HEW
CLASSIFICATION  #superfamily antifreeze protein SP1
KEYWORDS        antifreeze
SUMMARY         #length 62 #checksum 8795
SEQUENCE
                5        10        15        20        25        30
      1/S V V A T Q L I P I N T A L T P A M M E G K V T N P I G I P
     31 F A E M S Q I V G K Q V N R I V A K G Q T L M P N M V K T Y
     61 A A/
///
ENTRY           I51125  #type complete
TITLE           antifreeze protein - winter flounder
ORGANISM        #formal_name Pseudopleuronectes americanus #common_name
                winter flounder
DATE            13-Sep-1996 #sequence_revision 13-Sep-1996 #text_change
                24-Oct-2000
ACCESSIONS      I51125
REFERENCE       I51125
   #authors     Pickett, M.; Scott, G.; Davies, P.; Wang, N.; Joshi, S.;
                Hew, C.
   #journal     Eur. J. Biochem. (1984) 143:35-38
   #title       Sequence of an antifreeze protein precursor.
   #cross-references MUID:84285392; PMID:6547905
   #accession   I51125
      ##status preliminary; translated from GB/EMBL/DDBJ
      ##molecule_type mRNA
      ##residues 1-82 ##label PIC
      ##cross-references GB:M28337; NID:g213581; PIDN:AAA49466.1;
                PID:g213582
GENETICS
   #gene        AFP
CLASSIFICATION  #superfamily antifreeze protein
KEYWORDS        antifreeze
SUMMARY         #length 82  #molecular-weight 7697  #checksum 353
SEQUENCE
                5        10        15        20        25        30
      1 M A L S L F T V G Q L I F L F W T M R I T E A S P D P A A K
     31 A A P A A A A A P A A A A P D T A S D A A A A A A L T A A N
     61 A A A A A K L T A D N A A A A A A A T A R G
///
ENTRY           JH0626  #type complete
TITLE           antifreeze protein II precursor - rainbow smelt
ORGANISM        #formal_name Osmerus mordax #common_name rainbow smelt
DATE            10-Sep-1999 #sequence_revision 10-Sep-1999 #text_change
                10-Sep-1999
ACCESSIONS      JH0626; PS0361
REFERENCE       JH0626
   #authors     Ewart, K.V.; Rubinsky, B.; Fletcher, G.L.
   #journal     Biochem. Biophys. Res. Commun. (1992) 185:335-340
   #title       Structural and functional similarity between fish antifreeze
                proteins and calcium-dependent lectins.
   #cross-references MUID:92287116; PMID:1599470
   #accession   JH0626
      ##molecule_type mRNA
      ##residues 1-175 ##label EWA
      ##experimental_source liver
   #accession   PS0361
      ##molecule_type protein
      ##residues 145-154;162-173 ##label EWA1
COMMENT         This protein lowers solution freezing points
                non-colligatively (antifreeze activity) and protects
                mammalian cells from damage at hypothermic temperatures.
CLASSIFICATION  #superfamily tetranectin; C-type lectin homology
KEYWORDS        glycoprotein
FEATURE
   1-16                #domain signal sequence #status predicted #label SIG\
   17-175              #product antifreeze protein II #status predicted
                       #label ANT\
   38-159              #domain C-type lectin homology #label LCH\
   34                  #binding_site carbohydrate (Asn) (covalent) #status
                       predicted\
   38-49,66-159,
   135-151             #disulfide_bonds #status predicted
SUMMARY         #length 175  #molecular-weight 19055  #checksum 8439
SEQUENCE
                5        10        15        20        25        30
      1 M L A A L L V C A M V A L T R A A N G D T G K E A V M T G S
     31 S G K N L T E C P T D W K M F N G R C F L F N P L Q L H W A
     61 H A Q I S C M K D G A N L A S I H S L E E Y A F V K E L T T
     91 A G L I P A W I G G S D C H V S T Y W F W M D S T S M D F T
    121 D W C A A Q P D F T L T E C C I Q I N V G V G K C W N D T P
    151 C T H L H A S V C A K P A T V N P E V T P P S I M
///
ENTRY           JS0705  #type complete
TITLE           antifreeze protein (clones 1A-1a and 3-3a) - winter flounder
ORGANISM        #formal_name Pseudopleuronectes americanus #common_name
                winter flounder
DATE            17-Aug-1992 #sequence_revision 17-Aug-1992 #text_change
                24-Oct-2000
ACCESSIONS      JS0705
REFERENCE       JH0627
   #authors     Davies, P.L.
   #journal     Gene (1992) 112:163-170
   #title       Conservation of antifreeze protein-encoding genes in tandem
                repeats.
   #cross-references MUID:92209995; PMID:1555765
   #accession   JS0705
      ##molecule_type DNA
      ##residues 1-82 ##label DAV
      ##cross-references GB:M62413; NID:g213586; PIDN:AAA49468.1;
                PID:g213587
GENETICS
   #introns     19/2
CLASSIFICATION  #superfamily antifreeze protein
KEYWORDS        antifreeze
SUMMARY         #length 82  #molecular-weight 7794  #checksum 1127
SEQUENCE
                5        10        15        20        25        30
      1 M A L S L F T V G Q L I F L F W T M R I T E A R P D P A A K
     31 A A P A A A A V P A A A A P D T A S D A A A A A A L T A A N
     61 A A A A A K L T A D N A A A A A A A T A R G
///
ENTRY           JS0706  #type complete
TITLE           antifreeze protein (clone 4-2c) - winter flounder
ORGANISM        #formal_name Pseudopleuronectes americanus #common_name
                winter flounder
DATE            17-Aug-1992 #sequence_revision 17-Aug-1992 #text_change
                24-Oct-2000
ACCESSIONS      JS0706
REFERENCE       JH0627
   #authors     Davies, P.L.
   #journal     Gene (1992) 112:163-170
   #title       Conservation of antifreeze protein-encoding genes in tandem
                repeats.
   #cross-references MUID:92209995; PMID:1555765
   #accession   JS0706
      ##molecule_type DNA
      ##residues 1-82 ##label DAV
      ##cross-references GB:M62417; NID:g213594; PIDN:AAA49472.1;
                PID:g213595
      ##note the authors translated the codon AGC for residue 24 as Arg
GENETICS
   #introns     19/2
CLASSIFICATION  #superfamily antifreeze protein
KEYWORDS        antifreeze
SUMMARY         #length 82  #molecular-weight 7739  #checksum 1066
SEQUENCE
                5        10        15        20        25        30
      1 M A L S L F T V G Q L I F L F W T M R I T E A S P D P A A K
     31 A A P A A V A A P A A A A P D T A S D A A A A A A L T A A N
     61 A K A A A E L T A A N A A A A A A A T A R G
///
ENTRY           S02326  #type complete
TITLE           antifreeze protein A - winter flounder
ORGANISM        #formal_name Pseudopleuronectes americanus #common_name
                winter flounder
DATE            30-Sep-1989 #sequence_revision 30-Sep-1989 #text_change
                24-Oct-2000
ACCESSIONS      S02326; JH0627
REFERENCE       S02326
   #authors     Scott, G.K.; Davies, P.L.; Kao, M.H.; Fletcher, G.L.
   #journal     J. Mol. Evol. (1988) 27:29-35
   #title       Differential amplification of antifreeze protein genes in
                the Pleuronectinae.
   #cross-references MUID:88259236; PMID:3133486
   #accession   S02326
      ##molecule_type DNA
      ##residues 1-82 ##label SCO
      ##cross-references EMBL:X07506; NID:g64211; PIDN:CAA30389.1;
                PID:g64212
REFERENCE       JH0627
   #authors     Davies, P.L.
   #journal     Gene (1992) 112:163-170
   #title       Conservation of antifreeze protein-encoding genes in tandem
                repeats.
   #cross-references MUID:92209995; PMID:1555765
   #accession   JH0627
      ##molecule_type DNA
      ##residues 1-82 ##label DAV
      ##cross-references GB:M62415
GENETICS
   #introns     19/2
CLASSIFICATION  #superfamily antifreeze protein
KEYWORDS        antifreeze
SUMMARY         #length 82  #molecular-weight 7780  #checksum 286
SEQUENCE
                5        10        15        20        25        30
      1 M A L S L F T V G Q L I F L F W T M R I T E A R P D P A A K
     31 A A P A A A A A P A A A A P D T A S D A A A A A A L T A A N
     61 A K A A A E L T A A N A A A A A A A T A R G
///
ENTRY           S02376  #type complete
TITLE           antifreeze protein precursor - yellowtail flounder
ORGANISM        #formal_name Limanda ferruginea #common_name yellowtail
                flounder
DATE            01-Dec-1989 #sequence_revision 01-Dec-1989 #text_change
                24-Oct-2000
ACCESSIONS      S02376
REFERENCE       S02376
   #authors     Scott, G.K.; Davies, P.L.; Shears, M.A.; Fletcher, G.L.
   #journal     Eur. J. Biochem. (1987) 168:629-633
   #title       Structural variations in the alanine-rich antifreeze
                proteins of the Pleuronectinae.
   #cross-references MUID:88029483; PMID:3665937
   #accession   S02376
      ##molecule_type mRNA
      ##residues 1-97 ##label SCO
      ##cross-references EMBL:X06356; NID:g64041; PIDN:CAA29655.1;
                PID:g64042
      ##note part of this sequence, including the amino end of the mature
                protein, was confirmed by protein sequencing
CLASSIFICATION  #superfamily antifreeze protein
KEYWORDS        antifreeze
FEATURE
   1-23                #domain signal sequence #status predicted #label SIG\
   24-48               #domain propeptide #status predicted #label PRO\
   49-96               #product antifreeze protein #status predicted #label
                       MAT
SUMMARY         #length 97  #molecular-weight 8865  #checksum 3431
SEQUENCE
                5        10        15        20        25        30
      1 M A L S L F T V G Q L I F L F W T L R I T E A N P D P A A K
     31 A A P A A V A D P A A A A A A A V A D T A S D A A A A A A A
     61 T A A A A A K A A A D T A A A A A K A A A D T A A A A A E A
     91 A A A T A R G
///
ENTRY           S04973  #type complete
TITLE           antifreeze protein AB1 - Antarctic eelpout
ORGANISM        #formal_name Austrolycichthys brachycephalus #common_name
                Antarctic eelpout
DATE            07-Sep-1990 #sequence_revision 07-Sep-1990 #text_change
                24-Oct-2000
ACCESSIONS      S04973; B30095
REFERENCE       S04973
   #authors     Cheng, C.H.C.; DeVries, A.L.
   #journal     Biochim. Biophys. Acta (1989) 997:55-64
   #title       Structures of antifreeze peptides from the antarctic eel
                pout, Austrolycicthys brachycephalus.
   #cross-references MUID:89323219; PMID:2752054
   #accession   S04973
      ##molecule_type protein
      ##residues 1-63 ##label CHE
      ##note the accession number A30095 cited as assigned by EMBL is not in
                GenBank release 101.0
CLASSIFICATION  #superfamily antifreeze protein SP1
KEYWORDS        antifreeze
SUMMARY         #length 63  #molecular-weight 6846  #checksum 7531
SEQUENCE
                5        10        15        20        25        30
      1 T K S V V A S Q L I P I N T A L T P A M M K A K E V S P K G
     31 I P A E E M S K I V G M Q V N R A V N L D E T L M P D M V K
     61 T Y Q
///
ENTRY           S04974  #type complete
TITLE           antifreeze protein AB2 - Antarctic eelpout
ORGANISM        #formal_name Austrolycichthys brachycephalus #common_name
                Antarctic eelpout
DATE            07-Sep-1990 #sequence_revision 07-Sep-1990 #text_change
                24-Oct-2000
ACCESSIONS      S04974; A30095
REFERENCE       S04973
   #authors     Cheng, C.H.C.; DeVries, A.L.
   #journal     Biochim. Biophys. Acta (1989) 997:55-64
   #title       Structures of antifreeze peptides from the antarctic eel
                pout, Austrolycicthys brachycephalus.
   #cross-references MUID:89323219; PMID:2752054
   #accession   S04974
      ##molecule_type protein
      ##residues 1-63 ##label CHE
      ##note the accession number A30095 cited as assigned by EMBL is not in
                GenBank release 101.0
CLASSIFICATION  #superfamily antifreeze protein SP1
KEYWORDS        antifreeze
SUMMARY         #length 63  #molecular-weight 7001  #checksum 8250
SEQUENCE
                5        10        15        20        25        30
      1 T K S V V A N Q L I P I N T A L T L V M M K A E E V S P K G
     31 I P A E E I P R L V G M Q V N R A V Y L D E T L M P D M V K
     61 N Y E
///
ENTRY           S11155  #type complete
TITLE           cold and ABA inducible protein kin1 - Arabidopsis thaliana
ALTERNATE_NAMES protein F1N13_100
ORGANISM        #formal_name Arabidopsis thaliana #common_name mouse-ear
                cress
DATE            20-Feb-1995 #sequence_revision 20-Feb-1995 #text_change
                02-Sep-2000
ACCESSIONS      S11155; T51379
REFERENCE       S11155
   #authors     Kurkela, S.; Franck, M.
   #journal     Plant Mol. Biol. (1990) 15:137-144
   #title       Cloning and characterization of a cold- and ABA-inducible
                Arabidopsis gene.
   #cross-references MUID:91355846; PMID:2151730
   #accession   S11155
      ##molecule_type DNA
      ##residues 1-66 ##label KUR
      ##cross-references EMBL:X51474; NID:g16349; PIDN:CAA35838.1;
                PID:g296033
      ##note mRNA was also sequenced
REFERENCE       Z25393
   #authors     Sato, S.; Nakamura, Y.; Kaneko, T.; Kato, T.; Asamizu, E.;
                Kotani, H.; Tabata, S.; Bancroft, I.; Mewes, H.W.; Rudd, S.;
                Lemcke, K.; Mayer, K.F.X.
   #submission  submitted to the Protein Sequence Database, August 2000
   #accession   T51379
      ##status preliminary
      ##molecule_type DNA
      ##residues 1-66 ##label SAT
      ##cross-references EMBL:AL391145
      ##experimental_source cultivar Columbia; BAC clone F1N13
COMMENT         inducible by cold and also by abscisic acid (ABA) and water
                stress; protein kin1 shows similarity to fish antifreeze
                protein.
GENETICS
   #gene        kin1
   #map_position 5
   #introns     19/2; 42/2
   #note        F1N13_100
SUMMARY         #length 66  #molecular-weight 6495  #checksum 3455
SEQUENCE
                5        10        15        20        25        30
      1 M S E T N K N A F Q A G Q T A G K A E E K S N V L L D K A K
     31 D A A A G A G A G A Q Q A G K S V S D A A A G G V N F V K D
     61 K T G L N K
///
ENTRY           S53512  #type complete
TITLE           antifreeze protein RD1 - eelpout (Lycodichthys dearborni)
ORGANISM        #formal_name Lycodichthys dearborni
DATE            15-Jul-1995 #sequence_revision 21-Jul-1995 #text_change
                24-Oct-2000
ACCESSIONS      S53512
REFERENCE       S53512
   #authors     Wang, X.; DeVries, A.L.; Cheng, C.H.C.
   #journal     Biochim. Biophys. Acta (1995) 1247:163-172
   #title       Antifreeze peptide heterogeneity in an antarctic eel pout
                includes an unusually large major variant comprised of two 7
                kDa type III AFPs linked in tandem.
   #cross-references MUID:95210308; PMID:7696304
   #accession   S53512
      ##status preliminary
      ##molecule_type protein
      ##residues 1-64 ##label WAN
CLASSIFICATION  #superfamily antifreeze protein SP1
KEYWORDS        antifreeze
SUMMARY         #length 64  #molecular-weight 6906  #checksum 9758
SEQUENCE
                5        10        15        20        25        30
      1 N K A S V V A N Q L I P I N T A L T L I M M K A E V V T P M
     31 G I P A E E I P K L V G M Q V N R A V P L G T T L M P D M V
     61 K N Y E
///
ENTRY           S53514  #type complete
TITLE           antifreeze protein RD3 - eelpout (Lycodichthys dearborni)
ORGANISM        #formal_name Lycodichthys dearborni
DATE            15-Jul-1995 #sequence_revision 21-Jul-1995 #text_change
                17-Mar-1999
ACCESSIONS      S53514
REFERENCE       S53512
   #authors     Wang, X.; DeVries, A.L.; Cheng, C.H.C.
   #journal     Biochim. Biophys. Acta (1995) 1247:163-172
   #title       Antifreeze peptide heterogeneity in an antarctic eel pout
                includes an unusually large major variant comprised of two 7
                kDa type III AFPs linked in tandem.
   #cross-references MUID:95210308; PMID:7696304
   #accession   S53514
      ##status preliminary
      ##molecule_type protein
      ##residues 1-134 ##label WAN
SUMMARY         #length 134  #molecular-weight 14480  #checksum 921
SEQUENCE
                5        10        15        20        25        30
      1 N K A S V V A N Q L I P I N T A L T L I M M K A E V V T P M
     31 G I P A E E I P N L V G M Q V N R A V P L G T T L M P D M V
     61 K N Y E D G T T S P G L K S V V A N Q L I P I N T A L T L V
     91 M M K A E E V S P K G I P S E E I S K L V G M Q V N R A V Y
    121 L D Q T L M P D M V K N Y E
///
ENTRY           T14845  #type complete
TITLE           antifreeze-like protein (af70) - Norway spruce
ORGANISM        #formal_name Picea abies #common_name Norway spruce
DATE            20-Sep-1999 #sequence_revision 20-Sep-1999 #text_change
                20-Jun-2000
ACCESSIONS      T14845
REFERENCE       Z18237
   #authors     Sabala, I.; Franzen, H.; von Arnold, S.
   #submission  submitted to the EMBL Data Library, April 1996
   #description Characteriozation of a spruce gene constitutively expressed
                in somatic embryos and induced by ABA and low temperature in
                seedlings.
   #accession   T14845
      ##status preliminary; translated from GB/EMBL/DDBJ
      ##molecule_type mRNA
      ##residues 1-779 ##label SAB
      ##cross-references EMBL:D86598
      ##experimental_source embryogenic suspension cultures
CLASSIFICATION  #superfamily subtilisin-like proteinase ag12; subtilisin
                homology
SUMMARY         #length 779  #molecular-weight 82832  #checksum 2539
SEQUENCE
                5        10        15        20        25        30
      1 M M G L K L Y F A L V F L C S L L F G P V I A E D G K V H I
     31 V Y M G S L S H N N R E D L V T S H L E V L S S V L E S P R
     61 H A K Q S L V R S Y T Y A F N G F A A V L S K E Q A T T L V
     91 G K P G V L S V F P D T V L N L H T T H S W D Y L E K D L S
    121 M P G F S Y R K P K S S G T D I I L G F L D T G I W P E A A
    151 S F S D K G M G P V P S R W K G A C V K G E N F N V S N C N
    181 R K I I G A R Y Y S G G E D D D L K K N S K P K S I W P E S
    211 R T A R D Y Q G H G T Y T A A T A A G S F V D N A N Y N G L
    241 A N G T A R G G S A S S S T R I A M Y R V C G L D Y G C P G
    271 V Q I L A A F D D A V K D G V D I V S I S I G V R S S N Q A
    301 D F V K D A I A I G A F H A T Q K G I L V V S S A G N E G P
    331 D S Q T V V N A A P W I F T V G A T S I D R E F L S N V V L
    361 G N G K I I K G K G I T M S N L S H S A V H P L V Y A G S I
    391 P D K S S Y P V A A S N C L L D S L D A S K A K G N V V V C
    421 I A N D T A A S R Y I M K L A V Q D A G G I G M V V V E D I
    451 Q I F E A F D Y G T F P A T A V S K T S A T E I F S Y I K S
    481 N R N P V A T I T L T E V V T N Y I P A P V I A S F S S R G
    511 P G G L T Q N I L K P D I S A P G V N I I A A W N P P N Q S
    541 D E D T V V S E M T P S T F N M M S G T S V A V P H V T G A
    571 A A F V K S I N P T W S S S A I R S A L M T T A I V R N N M
    601 G K L L T N E S D I P G T P F D F G A G V V N P I G A L Q P
    631 G L V Y E T S I D D Y F H F L C N Y G L D S E N I K I I A A
    661 N E S Y K C P S G V N A D L I S N M N Y P S I A I S K L G I
    691 K N G S T T I S R S V T N F V P E Q A P T Y K V T I D A P P
    721 G L N V K V S P E I L H F S K T S K K L S F N V V F T P T N
    751 V A T K G Y A F G T L V W S D G K H N V R S P F A V N M V
///
ENTRY           T44768  #type complete
TITLE           antifreeze glycopeptide AFGP polyprotein precursor
                [imported] - Boreogadus saida
ORGANISM        #formal_name Boreogadus saida
DATE            21-Jan-2000 #sequence_revision 21-Jan-2000 #text_change
                21-Jul-2000
ACCESSIONS      T44768
REFERENCE       Z22834
   #authors     Chen, L.; DeVries, A.L.; Cheng, C.H.C.
   #journal     Proc. Natl. Acad. Sci. U.S.A. (1997) 94:3817-3822
   #title       Convergent evolution of antifreeze glycopeptides in
                Antarctic notothenioid fish and Arctic Cod.
   #cross-references MUID:97268653; PMID:9108061
   #accession   T44768
      ##status preliminary; translated from GB/EMBL/DDBJ
      ##molecule_type DNA
      ##residues 1-507 ##label CHE
      ##cross-references EMBL:U43200; NID:g2078482; PIDN:AAC60129.1;
                PID:g2078483
GENETICS
   #introns     1/3
SUMMARY         #length 507  #molecular-weight 44684  #checksum 2297
SEQUENCE
                5        10        15        20        25        30
      1 M L T G S C L L G P S C T S S P R Y E Q H Q L L V A R P A A
     31 A A R A A T P A T A A T P A T A A T P A T A A T A A T E A T
     61 A A T A A T P A T A A T P A T A A T A A T T A A T A A T A A
     91 T A A T P A R A A R A A T P A T A A T P A T A A T A A T A A
    121 T A A T A E T P A R A A T P A T A A T P A T A A T P A T A A
    151 T A A T A A T S A T A A T A A R A A T P A T A A T P A T P A
    181 T A A R A A R A A T P A T A A T A A T A A T A A T A A T A A
    211 T A A T A A T P A R A A R A A T P A T A P T P A T A A T P A
    241 T A A T A A T A P T A A T P A R A A R A A T P A T A A T L A
    271 T A A T P A T P A T P A T A A T D A T A A T A A T P A R A A
    301 T P A T P A T A A T P A T P A T A A T A A T A A T A A T A A
    331 T P A R A A R A A T P A T A A T P A T A A T A A T A A T A A
    361 T A A T A A T P A R A A R A A T P A T A A T A A T A A T A A
    391 T A A T A A T P A R A A R A A T P A T P A T P A T P A T P A
    421 T A A T A A T A A T A A T A A T A A T A A T A A T A P T P A
    451 R A A R A A T P A T G A T P A T A P T A G T A A T A A T A A
    481 T A A T P A R A S T P A T A A T P V T A A T P A A V F
///
ENTRY           T51008  #type complete
TITLE           related to antifreeze glycopeptide AFGP polyprotein
                precursor [imported] - Neurospora crassa
ALTERNATE_NAMES protein B7J19.70
ORGANISM        #formal_name Neurospora crassa
DATE            21-Jul-2000 #sequence_revision 21-Jul-2000 #text_change
                21-Jul-2000
ACCESSIONS      T51008
REFERENCE       Z25286
   #authors     Schulte, U.; Aign, V.; Hoheisel, J.; Brandt, P.; Fartmann,
                B.; Holland, R.; Nyakatura, G.; Mewes, H.W.; Mannhaupt, G.
   #submission  submitted to the Protein Sequence Database, July 2000
   #accession   T51008
      ##status preliminary
      ##molecule_type DNA
      ##residues 1-286 ##label SCH
      ##cross-references EMBL:AL389899; GSPDB:GN00116; NCSP:B7J19.70
      ##experimental_source BAC clone B7J19; strain OR74A
GENETICS
   #gene        NCSP:B7J19.70
   #map_position 6
SUMMARY         #length 286  #molecular-weight 28689  #checksum 581
SEQUENCE
                5        10        15        20        25        30
      1 M P P K A V A N G E S A C T L R G Q A L T S S E V K I L F G
     31 A L N N L T A P L D I D L Q G A A E T A G L K P N S Y K E M
     61 Y R Q F R R K Y E L G K P N A A A A A T A A V V V A S G G D
     91 G S N Q P V T T S T G S S S S T A T P K K A P G T A G G S G
    121 G G R P R A R P K K M L L T P G V G G G T N Q G V E A T L A
    151 T P G T P M G N L N F N D M T P E T P S K K A F G T S N K R
    181 S A T E A N P D E T P A K K G P A A R K P R V T A A T A K Q
    211 K A V A A A A A Q A E T K V K V E A A T D A G F S F I G D F
    241 V G N D V D A A M E G I S Q A A E A I E D T L A A A A A D E
    271 G Y I T A T E G G G P D Y G E I
///
