/*
 * Decompiled with CFR 0.152.
 */
package birchconfig;

import birchconfig.BufferedTextInputFile;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;

public class BirchProperties {
    String homedir;
    String adminUserid;
    String adminEmail;
    String platform;
    String birchURL;
    String birchHomeURL;
    String[] newstrParam = new String[6];
    String[] minibirchParam = new String[1];
    String minibirch;
    String BirchMasterCopy = "";
    Properties props = new Properties();

    public void GuessProps() {
        this.homedir = System.getProperty("user.home");
        this.adminUserid = System.getProperty("user.name");
        this.adminEmail = "";
        this.platform = "solaris-sparc";
        String OS = System.getProperty("os.name");
        System.out.println("OS: " + OS);
        String PLAT = System.getProperty("os.arch");
        System.out.println("Architecture: " + PLAT);
        this.platform = OS.toLowerCase().indexOf("linux") > -1 ? "linux-intel" : (OS.indexOf("SunOS") > -1 ? (PLAT.toLowerCase().indexOf("sparc") > -1 ? "solaris-sparc" : "solaris-amd64") : (OS.indexOf("Mac OS X") > -1 ? "osx-x86_64" : null));
        System.out.println("Platform set to: " + this.platform);
        this.birchHomeURL = "file://" + this.homedir;
        this.birchURL = "file://" + this.homedir + "/public_html";
        String paramfile = "local-generic/admin/BIRCH.mini";
        this.readParamFile(paramfile, this.minibirchParam);
        this.minibirch = this.minibirchParam[0].trim();
        System.out.println("miniBIRCH: " + this.minibirch);
    }

    private void readParamFile(String FN, String[] paramlines) {
        BufferedTextInputFile paramfile = new BufferedTextInputFile();
        if (paramfile.OpenOkay(FN)) {
            String line = paramfile.nextLine();
            int j = 0;
            while (line != null & j < paramlines.length) {
                paramlines[j] = line;
                line = paramfile.nextLine();
                ++j;
            }
        }
    }

    public void loadProps(String FN) {
        try {
            String propFN;
            String paramfile;
            this.props.load(new BufferedInputStream(new FileInputStream(FN)));
            this.homedir = this.props.getProperty("BirchProps.homedir", "");
            this.adminUserid = this.props.getProperty("BirchProps.adminUserid", "");
            this.adminEmail = this.props.getProperty("BirchProps.adminEmail", "");
            this.platform = this.props.getProperty("BirchProps.platform", "");
            this.birchURL = this.props.getProperty("BirchProps.birchURL", "");
            this.birchHomeURL = this.props.getProperty("BirchProps.birchHomeURL", "");
            this.minibirch = this.props.getProperty("BirchProps.minibirch", "");
            if (this.minibirch.equals("")) {
                paramfile = this.homedir + "/local-generic/admin/BIRCH.mini";
                this.readParamFile(paramfile, this.minibirchParam);
                this.minibirch = this.minibirchParam[0].trim();
                propFN = this.homedir + "/local/admin/BIRCH.properties";
                this.writeProps(propFN);
            }
            if (this.minibirch.equals("true")) {
                this.BirchMasterCopy = this.props.getProperty("BirchProps.BirchMasterCopy", "");
            }
            if (this.birchURL.equals("") | this.birchHomeURL.equals("")) {
                paramfile = this.homedir + "/local/admin/newstr.param";
                this.readParamFile(paramfile, this.newstrParam);
                this.birchURL = this.newstrParam[1];
                this.birchHomeURL = this.newstrParam[2];
                propFN = this.homedir + "/local/admin/BIRCH.properties";
                this.writeProps(propFN);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeProps(String FN) {
        try {
            if (this.adminEmail.trim().equals("")) {
                this.adminEmail = "noname@unknown_host";
            }
            System.out.println("Writing BIRCH.properties file");
            System.out.println(this.homedir);
            System.out.println(this.adminUserid);
            System.out.println(this.adminEmail);
            System.out.println(this.platform);
            System.out.println(this.birchURL);
            System.out.println(this.birchHomeURL);
            System.out.println(this.minibirch);
            System.out.println(this.BirchMasterCopy);
            this.props.setProperty("BirchProps.homedir", this.homedir);
            this.props.setProperty("BirchProps.adminUserid", this.adminUserid);
            this.props.setProperty("BirchProps.adminEmail", this.adminEmail);
            this.props.setProperty("BirchProps.platform", this.platform);
            this.props.setProperty("BirchProps.birchURL", this.birchURL);
            this.props.setProperty("BirchProps.birchHomeURL", this.birchHomeURL);
            this.props.setProperty("BirchProps.minibirch", this.minibirch);
            this.props.setProperty("BirchProps.BirchMasterCopy", this.BirchMasterCopy);
            FileOutputStream out = new FileOutputStream(FN);
            this.props.store(out, "Birch Properties");
            out.close();
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
    }

    public BirchProperties() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
    }
}

